/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncLongToLong
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncLongToLong function;
    private final StringFunctionBi stringFunction;

    public NodeFuncLongToLong(String name, IFuncLongToLong function) {
        this(function, (String a) -> "[ long -> long ] " + name + "(" + a + ")");
    }

    public NodeFuncLongToLong(IFuncLongToLong function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong a = stack.popLong();
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncLongToLong {
        public long apply(long var1);
    }

    private class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeLong argA;

        public Func(IExpressionNode.INodeLong argA) {
            this.argA = argA;
        }

        @Override
        public long evaluate() {
            return NodeFuncLongToLong.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncLongToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeLong)a), a -> new Func((IExpressionNode.INodeLong)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeLong)a), a -> NodeConstantLong.of(NodeFuncLongToLong.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncLongToLong.this.stringFunction.apply(this.argA.toString());
        }
    }
}

