/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeFuncLongLongToBoolean
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncLongLongToBoolean function;
    private final StringFunctionTri stringFunction;

    public NodeFuncLongLongToBoolean(String name, IFuncLongLongToBoolean function) {
        this(function, (String a, String b) -> "[ long, long -> boolean ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncLongLongToBoolean(IFuncLongLongToBoolean function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong b = stack.popLong();
        IExpressionNode.INodeLong a = stack.popLong();
        return new Func(a, b);
    }

    @FunctionalInterface
    public static interface IFuncLongLongToBoolean {
        public boolean apply(long var1, long var3);
    }

    private class Func
    implements IExpressionNode.INodeBoolean {
        private final IExpressionNode.INodeLong argA;
        private final IExpressionNode.INodeLong argB;

        public Func(IExpressionNode.INodeLong argA, IExpressionNode.INodeLong argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncLongLongToBoolean.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncLongLongToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b), (a, b) -> new Func((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func((IExpressionNode.INodeLong)a, (IExpressionNode.INodeLong)b), (a, b) -> NodeConstantBoolean.of(NodeFuncLongLongToBoolean.this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return NodeFuncLongLongToBoolean.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }
    }
}

