/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantLong;

public class NodeFuncDoubleToLong
extends NodeFuncBase
implements INodeFunc.INodeFuncLong {
    public final IFuncDoubleToLong function;
    private final StringFunctionBi stringFunction;

    public NodeFuncDoubleToLong(String name, IFuncDoubleToLong function) {
        this(function, (String a) -> "[ double -> long ] " + name + "(" + a + ")");
    }

    public NodeFuncDoubleToLong(IFuncDoubleToLong function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeLong getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble a = stack.popDouble();
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncDoubleToLong {
        public long apply(double var1);
    }

    private class Func
    implements IExpressionNode.INodeLong {
        private final IExpressionNode.INodeDouble argA;

        public Func(IExpressionNode.INodeDouble argA) {
            this.argA = argA;
        }

        @Override
        public long evaluate() {
            return NodeFuncDoubleToLong.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeLong inline() {
            if (!NodeFuncDoubleToLong.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeDouble)a), a -> new Func((IExpressionNode.INodeDouble)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeDouble)a), a -> NodeConstantLong.of(NodeFuncDoubleToLong.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncDoubleToLong.this.stringFunction.apply(this.argA.toString());
        }
    }
}

