/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantDouble;

public class NodeFuncDoubleToDouble
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncDoubleToDouble function;
    private final StringFunctionBi stringFunction;

    public NodeFuncDoubleToDouble(String name, IFuncDoubleToDouble function) {
        this(function, (String a) -> "[ double -> double ] " + name + "(" + a + ")");
    }

    public NodeFuncDoubleToDouble(IFuncDoubleToDouble function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble a = stack.popDouble();
        return new Func(a);
    }

    @FunctionalInterface
    public static interface IFuncDoubleToDouble {
        public double apply(double var1);
    }

    private class Func
    implements IExpressionNode.INodeDouble {
        private final IExpressionNode.INodeDouble argA;

        public Func(IExpressionNode.INodeDouble argA) {
            this.argA = argA;
        }

        @Override
        public double evaluate() {
            return NodeFuncDoubleToDouble.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncDoubleToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeDouble)a), a -> new Func((IExpressionNode.INodeDouble)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new Func((IExpressionNode.INodeDouble)a), a -> NodeConstantDouble.of(NodeFuncDoubleToDouble.this.function.apply(a.evaluate())));
        }

        public String toString() {
            return NodeFuncDoubleToDouble.this.stringFunction.apply(this.argA.toString());
        }
    }
}

