/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionTri;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;

public class NodeFuncDoubleDoubleToBoolean
extends NodeFuncBase
implements INodeFunc.INodeFuncBoolean {
    public final IFuncDoubleDoubleToBoolean function;
    private final StringFunctionTri stringFunction;

    public NodeFuncDoubleDoubleToBoolean(String name, IFuncDoubleDoubleToBoolean function) {
        this(function, (String a, String b) -> "[ double, double -> boolean ] " + name + "(" + a + ", " + b + ")");
    }

    public NodeFuncDoubleDoubleToBoolean(IFuncDoubleDoubleToBoolean function, StringFunctionTri stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}");
    }

    @Override
    public IExpressionNode.INodeBoolean getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble b = stack.popDouble();
        IExpressionNode.INodeDouble a = stack.popDouble();
        return new Func(a, b);
    }

    @FunctionalInterface
    public static interface IFuncDoubleDoubleToBoolean {
        public boolean apply(double var1, double var3);
    }

    private class Func
    implements IExpressionNode.INodeBoolean {
        private final IExpressionNode.INodeDouble argA;
        private final IExpressionNode.INodeDouble argB;

        public Func(IExpressionNode.INodeDouble argA, IExpressionNode.INodeDouble argB) {
            this.argA = argA;
            this.argB = argB;
        }

        @Override
        public boolean evaluate() {
            return NodeFuncDoubleDoubleToBoolean.this.function.apply(this.argA.evaluate(), this.argB.evaluate());
        }

        @Override
        public IExpressionNode.INodeBoolean inline() {
            if (!NodeFuncDoubleDoubleToBoolean.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b), (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, (a, b) -> new Func((IExpressionNode.INodeDouble)a, (IExpressionNode.INodeDouble)b), (a, b) -> NodeConstantBoolean.of(NodeFuncDoubleDoubleToBoolean.this.function.apply(a.evaluate(), b.evaluate())));
        }

        public String toString() {
            return NodeFuncDoubleDoubleToBoolean.this.stringFunction.apply(this.argA.toString(), this.argB.toString());
        }
    }
}

