/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.engine;

import buildcraft.api.blocks.ICustomRotationHandler;
import buildcraft.lib.block.BlockBCTile_Neptune;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.registry.RegistryConfig;
import buildcraft.lib.tile.TileBC_Neptune;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockEngineBase_BC8<E extends Enum<E>>
extends BlockBCTile_Neptune
implements ICustomRotationHandler {
    private final Map<E, Supplier<? extends TileEngineBase_BC8>> engineTileConstructors = new EnumMap<E, Supplier<? extends TileEngineBase_BC8>>(this.getEngineProperty().func_177699_b());

    public BlockEngineBase_BC8(Material material, String id) {
        super(material, id);
    }

    public void registerEngine(E type, Supplier<? extends TileEngineBase_BC8> constructor) {
        if (RegistryConfig.isEnabled("engines", this.getRegistryName() + "/" + ((Enum)type).name().toLowerCase(Locale.ROOT), this.getUnlocalizedName(type))) {
            this.engineTileConstructors.put(type, constructor);
        }
    }

    public boolean isRegistered(E type) {
        return this.engineTileConstructors.containsKey(type);
    }

    @Nonnull
    public ItemStack getStack(E type) {
        return new ItemStack((Block)this, 1, ((Enum)type).ordinal());
    }

    public abstract IProperty<E> getEngineProperty();

    public abstract E getEngineType(int var1);

    public abstract String getUnlocalizedName(E var1);

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getEngineProperty()});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        Enum type = (Enum)((Object)state.func_177229_b(this.getEngineProperty()));
        return type.ordinal();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        E engineType = this.getEngineType(meta);
        return this.func_176223_P().func_177226_a(this.getEngineProperty(), engineType);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase_BC8) {
            TileEngineBase_BC8 engine = (TileEngineBase_BC8)tile;
            if (side == engine.currentDirection.func_176734_d()) {
                return BlockFaceShape.SOLID;
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase_BC8) {
            TileEngineBase_BC8 engine = (TileEngineBase_BC8)tile;
            return side == engine.currentDirection.func_176734_d();
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public TileBC_Neptune createTileEntity(World world, IBlockState state) {
        Enum engineType = (Enum)((Object)state.func_177229_b(this.getEngineProperty()));
        Supplier<? extends TileEngineBase_BC8> constructor = this.engineTileConstructors.get(engineType);
        if (constructor == null) {
            return null;
        }
        TileEngineBase_BC8 tile = constructor.get();
        tile.func_145834_a(world);
        return tile;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Enum engine : this.getEngineProperty().func_177700_c()) {
            if (!this.engineTileConstructors.containsKey(engine)) continue;
            list.add((Object)new ItemStack((Block)this, 1, engine.ordinal()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.getEngineProperty()))).ordinal();
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase_BC8) {
            TileEngineBase_BC8 engine = (TileEngineBase_BC8)tile;
            engine.rotateIfInvalid();
        }
    }

    @Override
    public EnumActionResult attemptRotation(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase_BC8) {
            TileEngineBase_BC8 engine = (TileEngineBase_BC8)tile;
            return engine.attemptRotation();
        }
        return EnumActionResult.FAIL;
    }
}

