/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingFactory;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.IRecipeViewable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public enum GuideCraftingRecipes implements IStackRecipes
{
    INSTANCE;


    @Override
    public List<GuidePartFactory> getUsages(@Nonnull ItemStack target) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            GuidePartFactory factory;
            if (!GuideCraftingRecipes.checkRecipeUses(recipe, target) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
            list.add(factory);
        }
        return list;
    }

    private static boolean checkRecipeUses(IRecipe recipe, @Nonnull ItemStack target) {
        NonNullList ingrediants = recipe.func_192400_c();
        if (!ingrediants.isEmpty() || recipe instanceof IRecipeViewable) {
            // empty if block
        }
        for (Ingredient ing : ingrediants) {
            if (!ing.test((Object)target)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(@Nonnull ItemStack target, @Nullable Object in) {
        if (in instanceof ItemStack) {
            return StackUtil.doesEitherStackMatch((ItemStack)in, target);
        }
        if (in instanceof List) {
            for (Object obj : (List)in) {
                if (!(obj instanceof ItemStack) || !StackUtil.doesEitherStackMatch((ItemStack)obj, target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<GuidePartFactory> getRecipes(@Nonnull ItemStack target) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            GuidePartFactory factory;
            if (recipe instanceof IRecipeViewable) {
                ChangingItemStack changing = ((IRecipeViewable)recipe).getRecipeOutputs();
                if (!changing.matches(target) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
                list.add(factory);
                continue;
            }
            ItemStack out = StackUtil.asNonNull(recipe.func_77571_b());
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)out, (boolean)false) && !OreDictionary.itemMatches((ItemStack)out, (ItemStack)target, (boolean)false) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
            list.add(factory);
        }
        return list;
    }
}

