/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.api.statements.IAction;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.ITrigger;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.PageEntry;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.loader.XmlPageLoader;
import buildcraft.lib.client.guide.loader.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuidePage;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.client.guide.parts.contents.ContentsList;
import buildcraft.lib.client.render.font.ConfigurableFontRenderer;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.statement.GuiElementStatementSource;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.RenderUtil;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.SuffixArray;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GuidePageContents
extends GuidePageBase {
    private static final int ORDER_OFFSET_X = -50;
    private static final int ORDER_OFFSET_Y = 14;
    private final GuiTextField searchText;
    private String lastSearchText = "";
    private SuffixArray<ContentsList.Title.SubHeader.PageLink> quickSearcher;
    private final ContentsList contents;

    public GuidePageContents(GuiGuide gui) {
        super(gui);
        this.contents = new ContentsList(gui);
        this.loadMainGui();
        ConfigurableFontRenderer fr = new ConfigurableFontRenderer(gui.field_146297_k.field_71466_p).disableShadow();
        this.searchText = new GuiTextField(0, (FontRenderer)fr, 0, 0, 80, fr.field_78288_b + 5);
        this.searchText.func_146185_a(false);
        this.searchText.func_146193_g(-16777216);
    }

    public void loadMainGui() {
        TypeOrder order = GuiGuide.SORTING_TYPES[this.gui.sortingOrderIndex];
        this.contents.clear();
        this.quickSearcher = new SuffixArray();
        this.lastSearchText = "";
        HashSet<Item> itemsAdded = new HashSet<Item>();
        String underline = TextFormatting.UNDERLINE.toString();
        for (PageEntry entry : GuideManager.INSTANCE.getAllEntries()) {
            ItemStack stack;
            GuidePageFactory entryFactory = GuideManager.INSTANCE.getFactoryFor(entry);
            String[] ordered = entry.typeTags.getOrdered(order);
            String header = underline + LocaleUtil.localize(ordered[0]);
            String subHeader = underline + LocaleUtil.localize(ordered[1]);
            String translatedTitle = LocaleUtil.localize(entry.title);
            ISimpleDrawable icon = entry.createDrawable();
            PageLine line = new PageLine(icon, icon, 2, translatedTitle, true);
            GuideText text = new GuideText(this.gui, line);
            ContentsList.Title.SubHeader pageHolder = this.contents.getOrAddSubHeader(header, subHeader);
            if (entryFactory == null) {
                if (!(entry.value instanceof ItemStackValueFilter)) continue;
                stack = ((ItemStackValueFilter)entry.value).stack.baseStack;
                itemsAdded.add(stack.func_77973_b());
                ContentsList.Title.SubHeader.PageLinkGenerated pageLink = pageHolder.addKnownPage(text, stack);
                if (pageLink == null) continue;
                this.quickSearcher.func_194057_a((Object)pageLink, pageLink.joinedTooltip.toLowerCase(Locale.ROOT));
                continue;
            }
            if (entry.value instanceof ItemStackValueFilter) {
                stack = ((ItemStackValueFilter)entry.value).stack.baseStack;
                itemsAdded.add(stack.func_77973_b());
            }
            ContentsList.Title.SubHeader.PageLinkNormal pageLink = pageHolder.addNormalPage(text, entryFactory);
            this.quickSearcher.func_194057_a((Object)pageLink, pageLink.getName().toLowerCase(Locale.ROOT));
        }
        String localizedGroup = underline + "\u0379" + LocaleUtil.localize("buildcraft.guide.contents.all_group");
        String localizedItems = underline + LocaleUtil.localize("buildcraft.guide.contents.item_stacks");
        ContentsList.Title allTitle = this.contents.getOrAddTitle(localizedGroup);
        ContentsList.Title.SubHeader allHolder = allTitle.getOrAddSubHeader(localizedItems);
        block1: for (Item item : ForgeRegistries.ITEMS) {
            if (itemsAdded.contains(item)) continue;
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = (ItemStack)stacks.get(i);
                ContentsList.Title.SubHeader.PageLinkGenerated pageLink = allHolder.addUnknownStack(stack);
                if (pageLink != null) {
                    this.quickSearcher.func_194057_a((Object)pageLink, pageLink.joinedTooltip.toLowerCase(Locale.ROOT));
                }
                if (i > 50) continue block1;
            }
        }
        String localizedTriggers = underline + LocaleUtil.localize("buildcraft.guide.contents.triggers");
        String localizedActions = underline + LocaleUtil.localize("buildcraft.guide.contents.actions");
        ContentsList.Title.SubHeader triggers = allTitle.getOrAddSubHeader(localizedTriggers);
        ContentsList.Title.SubHeader actions = allTitle.getOrAddSubHeader(localizedActions);
        HashSet<IStatement> added = new HashSet<IStatement>();
        for (IStatement statement : new TreeMap<String, IStatement>(StatementManager.statements).values()) {
            if (!added.add(statement) || GuideManager.INSTANCE.getEntryFor(statement) != null) continue;
            ISimpleDrawable icon = (x, y) -> GuiElementStatementSource.drawGuiSlot(statement, x, y);
            List<String> tooltip = statement.getTooltip();
            String title = tooltip.isEmpty() ? statement.getUniqueTag() : tooltip.get(0);
            GuideText text = new GuideText(this.gui, new PageLine(icon, icon, 2, title, true));
            ContentsList.Title.SubHeader.PageLinkNormal pageLink = statement instanceof ITrigger ? triggers.addUnknownPage(text, g -> new GuidePage(this.gui, (List<GuidePart>)ImmutableList.of(), title)) : (statement instanceof IAction ? actions.addUnknownPage(text, g -> new GuidePage(this.gui, (List<GuidePart>)ImmutableList.of(), title)) : null);
            if (pageLink == null) continue;
            String joinedTooltip = tooltip.stream().collect(Collectors.joining(" ", "", ""));
            String searchSr = statement.getUniqueTag() + " " + joinedTooltip;
            this.quickSearcher.func_194057_a((Object)pageLink, searchSr.toLowerCase(Locale.ROOT));
        }
        this.quickSearcher.func_194058_a();
        this.contents.sortAll();
    }

    @Override
    public void setFontRenderer(IFontRenderer fontRenderer) {
        super.setFontRenderer(fontRenderer);
        this.contents.setFontRenderer(fontRenderer);
    }

    @Override
    public List<GuideChapter> getChapters() {
        return this.contents.getChapters();
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.searchText.func_146178_a();
        if (this.lastSearchText.equals(this.searchText.func_146179_b())) {
            if (this.numPages > 3 && this.getPage() > this.numPages) {
                this.goToPage(this.numPages);
            } else if (this.getPage() < 2) {
                this.searchText.func_146195_b(false);
            }
        } else {
            this.lastSearchText = this.searchText.func_146179_b().toLowerCase(Locale.ROOT);
            this.numPages = -1;
            if (this.lastSearchText.isEmpty()) {
                for (ContentsList.Title title : this.contents.sortedTitles) {
                    for (ContentsList.Title.SubHeader subHeader : title.sortedHeaders) {
                        for (ContentsList.Title.SubHeader.PageLink page : subHeader.pages) {
                            page.setVisible(page.startVisible);
                        }
                    }
                }
            } else {
                HashSet matches = new HashSet(this.quickSearcher.func_194055_a(this.lastSearchText));
                for (ContentsList.Title title : this.contents.sortedTitles) {
                    for (ContentsList.Title.SubHeader subHeader : title.sortedHeaders) {
                        for (ContentsList.Title.SubHeader.PageLink page : subHeader.pages) {
                            page.setVisible(matches.contains(page));
                        }
                    }
                }
                if (this.contents.isVisible()) {
                    this.searchText.func_146193_g(-16777216);
                } else {
                    this.searchText.func_146193_g(-65536);
                }
            }
            this.gui.refreshChapters();
        }
    }

    @Override
    protected void renderPage(int x, int y, int width, int height, int index) {
        IFontRenderer f = this.getFontRenderer();
        if (index == 0) {
            String text = "BuildCraft";
            float scale = 3.0f;
            int fWidth = (int)((float)f.getStringWidth(text) * scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)(y + height / 2 - 62) / scale), 0);
            GlStateManager.func_179121_F();
            text = "v7.99.17";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 - 36, 0);
            scale = 1.5f;
            text = LocaleUtil.localize("options.title");
            fWidth = (int)((float)f.getStringWidth(text) * scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)(y + height / 2 - 4) / scale), 0);
            GlStateManager.func_179121_F();
            text = XmlPageLoader.SHOW_LORE ? "Show Lore [x]" : "Show Lore [ ]";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 + 12, 0);
            text = XmlPageLoader.SHOW_HINTS ? "Show Hints [x]" : "Show Hints [ ]";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 + 26, 0);
        } else if (index == 1) {
            int _height = GuideManager.loadedMods.size() + 1;
            if (GuideManager.loadedOther.size() > 0) {
                ++_height;
                _height += GuideManager.loadedOther.size();
            }
            int perLineHeight = f.getFontHeight("Ly") + 3;
            int _y = y + (height - (_height *= perLineHeight)) / 2;
            this.drawCenteredText(TextFormatting.BOLD + "Loaded Mods:", x, _y, width);
            _y += perLineHeight;
            for (String text : GuideManager.loadedMods) {
                this.drawCenteredText(text, x, _y, width);
                _y += perLineHeight;
            }
            if (GuideManager.loadedOther.size() > 0) {
                this.drawCenteredText(TextFormatting.BOLD + "Loaded Resource Packs:", x, _y, width);
                _y += perLineHeight;
                for (String text : GuideManager.loadedOther) {
                    this.drawCenteredText(text, x, _y, width);
                    _y += perLineHeight;
                }
            }
        } else if (index % 2 == 0) {
            this.searchText.field_146209_f = x + 23;
            this.searchText.field_146210_g = y - 23;
            if (!this.searchText.func_146206_l() && this.searchText.func_146179_b().isEmpty()) {
                GuiGuide.SEARCH_TAB_CLOSED.drawAt(x + 8, y - 20);
                GuiGuide.SEARCH_ICON.drawAt(x + 8, y - 19);
            } else {
                GuiGuide.SEARCH_TAB_OPEN.drawAt(x - 2, y - 29);
                GuiGuide.SEARCH_ICON.drawAt(x + 8, y - 25);
            }
            this.searchText.func_146194_f();
        }
        RenderUtil.setGLColorFromInt(-1);
        GuidePart.PagePosition pos = new GuidePart.PagePosition(2, 0);
        for (ContentsList.Title title : this.contents.visibleTitles) {
            ContentsList.Title.SubHeader firstHeader = title.visibleHeaders[0];
            ContentsList.Title.SubHeader.PageLink firstPage = firstHeader.visiblePages[0];
            pos = pos.guaranteeSpace(32 + this.gui.getCurrentFont().getFontHeight(firstPage.text.text.text), height);
            pos = title.chapter.renderIntoArea(x, y, width, height, pos, index);
            for (ContentsList.Title.SubHeader header : title.visibleHeaders) {
                firstPage = header.visiblePages[0];
                pos = pos.guaranteeSpace(this.gui.getCurrentFont().getFontHeight(firstPage.text.text.text), height);
                pos = header.text.renderIntoArea(x, y, width, height, pos, index);
                for (ContentsList.Title.SubHeader.PageLink page : header.visiblePages) {
                    pos = page.renderIntoArea(x, y, width, height, pos, index);
                }
            }
        }
        if (this.numPages == -1) {
            this.numPages = pos.page + 1;
        }
        super.renderPage(x, y, width, height, index);
        if (index % 2 == 0) {
            int oX = x + -50;
            int oY = y + 14;
            int i = 0;
            for (GuiIcon icon : GuiGuide.ORDERS) {
                if (this.gui.sortingOrderIndex == i) {
                    icon = icon.offset(0.0, 14.0);
                }
                icon.drawAt(oX, oY);
                oY += 14;
                ++i;
            }
        }
    }

    private void drawCenteredText(String text, int x, int y, int width) {
        IFontRenderer f = this.getFontRenderer();
        int fWidth = f.getStringWidth(text);
        f.drawString(text, x + (width - fWidth) / 2, y, 0);
    }

    private void drawScaledCenteredText(float scale, String text, int x, int y, int width) {
        IFontRenderer f = this.getFontRenderer();
        int fWidth = (int)((float)f.getStringWidth(text) * scale);
        if (scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        }
        f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)y / scale), 0);
        if (scale != 1.0f) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void handleMouseClick(int x, int y, int width, int height, int mouseX, int mouseY, int mouseButton, int index, boolean isEditing) {
        GuiRectangle rect;
        super.handleMouseClick(x, y, width, height, mouseX, mouseY, mouseButton, index, isEditing);
        if (index % 2 == 0) {
            int oX = x + -50;
            int oY = y + 14;
            for (int i = 0; i < GuiGuide.ORDERS.length; ++i) {
                rect = new GuiRectangle(oX, oY, 14.0, 14.0);
                if (rect.contains(this.gui.mouse)) {
                    this.gui.sortingOrderIndex = i;
                    this.loadMainGui();
                    this.gui.refreshChapters();
                    this.contents.setFontRenderer(this.getFontRenderer());
                    return;
                }
                oY += 14;
            }
            if (!this.searchText.func_146192_a(mouseX, mouseY, mouseButton) && !this.searchText.func_146206_l() && new GuiRectangle(x - 2, y - 34, 40.0, 34.0).contains(mouseX, mouseY)) {
                this.searchText.func_146195_b(true);
            }
            if (mouseButton == 1 && mouseX >= this.searchText.field_146209_f && mouseX < this.searchText.field_146209_f + this.searchText.field_146218_h && mouseY >= this.searchText.field_146210_g && mouseY < this.searchText.field_146210_g + this.searchText.field_146219_i) {
                this.searchText.func_146180_a("");
            }
        }
        if (mouseButton == 0 && index == 0) {
            String text;
            IFontRenderer f = this.getFontRenderer();
            int fWidth = f.getStringWidth(text = XmlPageLoader.SHOW_LORE ? "Show Lore [x]" : "Show Lore [ ]");
            rect = new GuiRectangle(x + (width - fWidth) / 2, y + height / 2 + 12, fWidth, f.getFontHeight(text));
            if (rect.contains(mouseX, mouseY)) {
                XmlPageLoader.SHOW_LORE = !XmlPageLoader.SHOW_LORE;
            }
            if ((rect = new GuiRectangle(x + (width - (fWidth = f.getStringWidth(text = XmlPageLoader.SHOW_HINTS ? "Show Hints [x]" : "Show Hints [ ]"))) / 2, y + height / 2 + 26, fWidth, f.getFontHeight(text))).contains(mouseX, mouseY)) {
                boolean bl = XmlPageLoader.SHOW_HINTS = !XmlPageLoader.SHOW_HINTS;
            }
        }
        if (new GuiRectangle(x, y, width, height).contains(mouseX, mouseY)) {
            GuidePart.PagePosition pos = new GuidePart.PagePosition(2, 0);
            block1: for (ContentsList.Title title : this.contents.visibleTitles) {
                ContentsList.Title.SubHeader firstHeader = title.visibleHeaders[0];
                ContentsList.Title.SubHeader.PageLink firstPage = firstHeader.visiblePages[0];
                pos = pos.guaranteeSpace(32 + this.gui.getCurrentFont().getFontHeight(firstPage.text.text.text), height);
                pos = title.chapter.renderIntoArea(x, y, width, height, pos, -1);
                for (ContentsList.Title.SubHeader header : title.visibleHeaders) {
                    firstPage = header.visiblePages[0];
                    pos = pos.guaranteeSpace(this.gui.getCurrentFont().getFontHeight(firstPage.text.text.text), height);
                    pos = header.text.renderIntoArea(x, y, width, height, pos, -1);
                    for (ContentsList.Title.SubHeader.PageLink page : header.visiblePages) {
                        pos = page.text.renderIntoArea(x, y, width, height, pos, -1);
                        if (pos.page != index || !page.text.wasHovered()) continue;
                        page.onClicked();
                        break block1;
                    }
                }
            }
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.searchText.func_146201_a(typedChar, keyCode);
    }
}

