/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuideChapterWithin;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.gui.GuiStack;
import buildcraft.lib.misc.StringUtilBC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ContentsList {
    public final GuiGuide gui;
    private final Map<String, Title> titles = new HashMap<String, Title>();
    private List<GuideChapter> chapters;
    Title[] sortedTitles = null;
    Title[] visibleTitles = null;

    public ContentsList(GuiGuide gui) {
        this.gui = gui;
    }

    public Title getOrAddTitle(String title) {
        this.sortedTitles = null;
        return this.titles.computeIfAbsent(title, x$0 -> new Title((String)x$0));
    }

    public Title.SubHeader getOrAddSubHeader(String title, String subHeader) {
        this.sortedTitles = null;
        return this.getOrAddTitle(title).getOrAddSubHeader(subHeader);
    }

    public void clear() {
        this.titles.clear();
        this.chapters = null;
        this.sortedTitles = null;
        this.visibleTitles = null;
    }

    public void sortAll() {
        this.sortedTitles = this.titles.values().toArray(new Title[0]);
        Arrays.sort(this.sortedTitles, StringUtilBC.compareBasicReadable(t -> t.title));
        for (Title title : this.sortedTitles) {
            title.sortHeaders();
        }
        this.calcVisibility();
    }

    public void setFontRenderer(IFontRenderer fontRenderer) {
        if (this.sortedTitles == null) {
            this.sortAll();
        }
        for (Title title : this.sortedTitles) {
            title.setFontRenderer(fontRenderer);
        }
    }

    public List<GuideChapter> getChapters() {
        if (this.chapters == null) {
            if (this.visibleTitles == null) {
                this.sortAll();
            }
            GuideChapter[] chArray = new GuideChapter[this.visibleTitles.length];
            for (int i = 0; i < this.visibleTitles.length; ++i) {
                chArray[i] = this.visibleTitles[i].chapter;
            }
            this.chapters = Arrays.asList(chArray);
        }
        return this.chapters;
    }

    public boolean isVisible() {
        return this.visibleTitles != null && this.visibleTitles.length != 0;
    }

    private void calcVisibility() {
        ArrayList<Title> visible = new ArrayList<Title>();
        for (Title title : this.sortedTitles) {
            if (!title.isVisible()) continue;
            visible.add(title);
        }
        this.visibleTitles = visible.toArray(new Title[0]);
        this.chapters = null;
    }

    public class Title {
        public final String title;
        public final GuideChapterWithin chapter;
        private final Map<String, SubHeader> subHeaders = new HashMap<String, SubHeader>();
        SubHeader[] sortedHeaders = null;
        SubHeader[] visibleHeaders = null;

        public Title(String title) {
            this.title = title;
            this.chapter = new GuideChapterWithin(ContentsList.this.gui, title);
        }

        public boolean isVisible() {
            return this.visibleHeaders != null && this.visibleHeaders.length != 0;
        }

        public SubHeader getOrAddSubHeader(String subHeader) {
            this.sortedHeaders = null;
            return this.subHeaders.computeIfAbsent(subHeader, x$0 -> new SubHeader((String)x$0));
        }

        private void sortHeaders() {
            this.sortedHeaders = this.subHeaders.values().toArray(new SubHeader[0]);
            Arrays.sort(this.sortedHeaders, StringUtilBC.compareBasicReadable(s -> s.subHeader));
            for (SubHeader header : this.sortedHeaders) {
                header.sortPages();
            }
            this.calcVisibility();
        }

        private void setFontRenderer(IFontRenderer fontRenderer) {
            if (this.sortedHeaders == null) {
                throw new IllegalStateException("Must always call sort() before setFontRenderer!");
            }
            this.chapter.setFontRenderer(fontRenderer);
            for (SubHeader subHeader : this.sortedHeaders) {
                subHeader.setFontRenderer(fontRenderer);
            }
        }

        private void calcVisibility() {
            ArrayList<SubHeader> visible = new ArrayList<SubHeader>();
            for (SubHeader page : this.sortedHeaders) {
                if (!page.isVisible()) continue;
                visible.add(page);
            }
            this.visibleHeaders = visible.toArray(new SubHeader[0]);
        }

        public class SubHeader {
            public final String subHeader;
            public final GuideText text;
            final List<PageLink> pages = new ArrayList<PageLink>();
            PageLink[] visiblePages = null;

            public SubHeader(String subHeader) {
                this.subHeader = subHeader;
                this.text = new GuideText(ContentsList.this.gui, new PageLine(2, subHeader, false));
            }

            public boolean isVisible() {
                return this.visiblePages != null && this.visiblePages.length != 0;
            }

            private void sortPages() {
                this.pages.sort(StringUtilBC.compareBasicReadable(PageLink::getName));
                this.calcVisibility();
            }

            private void calcVisibility() {
                ArrayList<PageLink> visible = new ArrayList<PageLink>();
                for (PageLink page : this.pages) {
                    if (!page.isVisible()) continue;
                    visible.add(page);
                }
                this.visiblePages = visible.toArray(new PageLink[0]);
            }

            private void setFontRenderer(IFontRenderer fontRenderer) {
                this.text.setFontRenderer(fontRenderer);
                for (PageLink pageLink : this.pages) {
                    pageLink.text.setFontRenderer(fontRenderer);
                }
            }

            public PageLinkNormal addNormalPage(GuideText text, GuidePageFactory factory) {
                PageLinkNormal page = new PageLinkNormal(text, factory, true);
                this.pages.add(page);
                return page;
            }

            public PageLinkNormal addUnknownPage(GuideText text, GuidePageFactory factory) {
                PageLinkNormal page = new PageLinkNormal(text, factory, false);
                this.pages.add(page);
                return page;
            }

            @Nullable
            public PageLinkGenerated addKnownPage(GuideText text, ItemStack stack) {
                if (stack.func_190926_b()) {
                    return null;
                }
                PageLinkGenerated pageLink = new PageLinkGenerated(text, stack, true);
                this.pages.add(pageLink);
                return pageLink;
            }

            @Nullable
            public PageLinkGenerated addUnknownStack(ItemStack stack) {
                if (stack.func_190926_b()) {
                    return null;
                }
                GuiStack icon = new GuiStack(stack);
                PageLine line = new PageLine(icon, icon, 2, stack.func_82833_r(), true);
                GuideText textEntry = new GuideText(ContentsList.this.gui, line);
                PageLinkGenerated pageLink = new PageLinkGenerated(textEntry, stack, false);
                this.pages.add(pageLink);
                return pageLink;
            }

            public class PageLinkGenerated
            extends PageLink {
                public final ItemStack stack;
                public final List<String> tooltip;
                public final String joinedTooltip;

                PageLinkGenerated(GuideText text, ItemStack stack, boolean forceVisible) {
                    super(text, forceVisible);
                    this.stack = stack;
                    this.tooltip = ContentsList.this.gui.func_191927_a(stack);
                    this.joinedTooltip = this.tooltip.stream().collect(Collectors.joining(" ", "", ""));
                }

                @Override
                public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition pos, int index) {
                    pos = super.renderIntoArea(x, y, width, height, pos, index);
                    if (pos.page == index && this.text.wasHovered() && this.tooltip.size() > 1) {
                        ContentsList.this.gui.tooltipStack = this.stack;
                    }
                    return pos;
                }

                @Override
                public void onClicked() {
                    ContentsList.this.gui.openPage(GuideManager.INSTANCE.getPageFor(this.stack).createNew(ContentsList.this.gui));
                }
            }

            public class PageLinkTag
            extends PageLink {
                public final NonNullList<ItemStack> containedStacks;

                PageLinkTag(GuideText text, NonNullList<ItemStack> containedStacks) {
                    super(text, false);
                    this.containedStacks = containedStacks;
                }

                @Override
                public void onClicked() {
                    BCLog.logger.info("[lib.guide] Clicked tag entry! (" + this.text.text.text + ")");
                }
            }

            public class PageLinkNormal
            extends PageLink {
                public final GuidePageFactory factory;

                public PageLinkNormal(GuideText text, GuidePageFactory factory, boolean startVisible) {
                    super(text, startVisible);
                    this.factory = factory;
                }

                @Override
                public void onClicked() {
                    ContentsList.this.gui.openPage(this.factory.createNew(ContentsList.this.gui));
                }
            }

            public abstract class PageLink {
                public final GuideText text;
                public final boolean startVisible;
                private boolean visible;

                PageLink(GuideText text, boolean startVisible) {
                    this.text = text;
                    this.startVisible = startVisible;
                    this.visible = startVisible;
                }

                public boolean isVisible() {
                    return this.visible;
                }

                public void setVisible(boolean visible) {
                    if (visible == this.visible) {
                        return;
                    }
                    this.visible = visible;
                    SubHeader.this.calcVisibility();
                    Title.this.calcVisibility();
                    ContentsList.this.calcVisibility();
                }

                public final String getName() {
                    return this.text.text.text;
                }

                public abstract void onClicked();

                public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition pos, int index) {
                    return this.text.renderIntoArea(x, y, width, height, pos, index);
                }
            }
        }
    }
}

