/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuideChapterContents;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.misc.StringUtilBC;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class GuidePage
extends GuidePageBase {
    public final ImmutableList<GuidePart> parts;
    public final String title;
    public final GuideChapter chapterContents;

    public GuidePage(GuiGuide gui, List<GuidePart> parts, String title) {
        super(gui);
        this.parts = ImmutableList.copyOf(parts);
        this.title = StringUtilBC.formatStringForWhite(title);
        this.chapterContents = new GuideChapterContents(gui);
    }

    @Override
    public List<GuideChapter> getChapters() {
        ArrayList<GuideChapter> list = new ArrayList<GuideChapter>();
        list.add(this.chapterContents);
        for (GuidePart part : this.parts) {
            if (!(part instanceof GuideChapter)) continue;
            list.add((GuideChapter)part);
        }
        return list;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setFontRenderer(IFontRenderer fontRenderer) {
        super.setFontRenderer(fontRenderer);
        for (GuidePart part : this.parts) {
            part.setFontRenderer(fontRenderer);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        for (GuidePart part : this.parts) {
            part.updateScreen();
        }
    }

    @Override
    protected void renderPage(int x, int y, int width, int height, int index) {
        super.renderPage(x, y, width, height, index);
        GuidePart.PagePosition part = new GuidePart.PagePosition(0, 0);
        for (GuidePart guidePart : this.parts) {
            part = guidePart.renderIntoArea(x, y, width, height, part, index);
            if (this.numPages == -1 || part.page <= index) continue;
            break;
        }
        if (this.numPages == -1) {
            this.numPages = part.newPage().page;
        }
    }

    @Override
    public void handleMouseClick(int x, int y, int width, int height, int mouseX, int mouseY, int mouseButton, int index, boolean isEditing) {
        super.handleMouseClick(x, y, width, height, mouseX, mouseY, mouseButton, index, isEditing);
        GuidePart.PagePosition part = new GuidePart.PagePosition(0, 0);
        for (GuidePart guidePart : this.parts) {
            part = guidePart.handleMouseClick(x, y, width, height, part, index, mouseX, mouseY);
            if (this.numPages == -1 || part.page <= index) continue;
            break;
        }
    }
}

