/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.loader.entry;

import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import buildcraft.lib.client.guide.loader.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.loader.entry.PageEntryType;
import buildcraft.lib.gui.GuiStack;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.ItemStackKey;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntryTypeItem
extends PageEntryType<ItemStackValueFilter> {
    public static final String ID = "minecraft:item_stack";
    public static final EntryTypeItem INSTANCE = new EntryTypeItem();

    @Override
    @Nullable
    public ItemStackValueFilter deserialise(String source) {
        boolean matchNbt;
        boolean matchMeta;
        ItemStack stack;
        if (source.startsWith("{") && source.endsWith("}")) {
            stack = MarkdownPageLoader.loadComplexItemStack(source.substring(1, source.length() - 1));
            stack.func_190920_e(1);
            matchMeta = true;
            matchNbt = stack.func_77942_o();
        } else {
            Item item;
            if (source.startsWith("(") && source.endsWith(")")) {
                source = source.substring(1, source.length() - 1);
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(source))) == null) {
                return null;
            }
            stack = new ItemStack(item);
            matchMeta = false;
            matchNbt = false;
        }
        if (stack.func_190926_b()) {
            return null;
        }
        return new ItemStackValueFilter(new ItemStackKey(stack), matchMeta, matchNbt);
    }

    @Override
    public List<String> getTooltip(ItemStackValueFilter value) {
        return GuiUtil.getFormattedTooltip(value.stack.baseStack);
    }

    @Override
    public boolean matches(ItemStackValueFilter target, Object value) {
        if (value instanceof ItemStackKey) {
            value = ((ItemStackKey)value).baseStack;
        }
        if (value instanceof ItemStack) {
            ItemStack base = target.stack.baseStack;
            ItemStack test = (ItemStack)value;
            if (base.func_190926_b() || test.func_190926_b()) {
                return false;
            }
            if (base.func_77973_b() != test.func_77973_b()) {
                return false;
            }
            if (target.matchMeta && base.func_77960_j() != test.func_77960_j()) {
                return false;
            }
            return !target.matchNbt || ItemStack.func_77970_a((ItemStack)base, (ItemStack)test);
        }
        return false;
    }

    @Override
    @Nullable
    public ISimpleDrawable createDrawable(ItemStackValueFilter value) {
        return new GuiStack(value.stack.baseStack);
    }
}

