/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.data;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.data.JsonEntry;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JsonContents {
    public final JsonEntry[] contents;
    @SerializedName(value="default_tags")
    public final JsonTypeTags defaultTags;
    @SerializedName(value="entry_mask")
    public final String entryMask;

    public JsonContents(String entryMask, JsonTypeTags defaultTags, JsonEntry[] contents) {
        this.contents = contents;
        this.defaultTags = defaultTags;
        this.entryMask = entryMask;
    }

    public JsonContents inheritMissingTags() {
        JsonTypeTags tags = this.defaultTags == null ? JsonTypeTags.EMPTY : this.defaultTags.inheritMissingTags(JsonTypeTags.EMPTY);
        JsonEntry[] entries = new JsonEntry[this.contents.length];
        int j = 0;
        for (JsonEntry entry : this.contents) {
            if (entry == null) continue;
            entries[j] = entry.inherit(tags, this.entryMask);
            ++j;
        }
        entries = Arrays.copyOf(entries, j);
        return new JsonContents(this.entryMask, tags, entries);
    }

    public static List<JsonEntry> mergeAll(Iterable<JsonContents> all) {
        ArrayList<JsonEntry> entries = new ArrayList<JsonEntry>();
        for (JsonContents contents : all) {
            if (contents == null) continue;
            contents = contents.inheritMissingTags();
            Collections.addAll(entries, contents.contents);
        }
        return entries;
    }

    public void printContents() {
        BCLog.logger.info("{");
        if (this.defaultTags == null) {
            BCLog.logger.info("  default_tags = null");
        } else {
            BCLog.logger.info("  default_tags = {");
            this.defaultTags.printContents(2);
            BCLog.logger.info("  },");
        }
        if (this.contents == null) {
            BCLog.logger.info("  contents = null");
        } else {
            BCLog.logger.info("  contents = [");
            for (int i = 0; i < this.contents.length; ++i) {
                boolean last;
                JsonEntry entry = this.contents[i];
                boolean bl = last = i + 1 == this.contents.length;
                if (entry == null) {
                    if (last) {
                        BCLog.logger.info("    null");
                        continue;
                    }
                    BCLog.logger.info("    null,");
                    continue;
                }
                BCLog.logger.info("    {");
                entry.printContents();
                if (last) {
                    BCLog.logger.info("    }");
                    continue;
                }
                BCLog.logger.info("    },");
            }
            BCLog.logger.info("  ]");
        }
        BCLog.logger.info("}");
    }
}

