/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.lib.client.guide.ETypeTag;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.font.FontManager;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.contents.GuidePageContents;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.MousePosition;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiGuide
extends GuiScreen {
    public static final ResourceLocation ICONS_1 = Gui.field_110324_m;
    public static final ResourceLocation ICONS_2 = new ResourceLocation("buildcraftlib:textures/gui/guide/icons.png");
    public static final ResourceLocation COVER = new ResourceLocation("buildcraftlib:textures/gui/guide/cover.png");
    public static final ResourceLocation LEFT_PAGE = new ResourceLocation("buildcraftlib:textures/gui/guide/left_page.png");
    public static final ResourceLocation RIGHT_PAGE = new ResourceLocation("buildcraftlib:textures/gui/guide/right_page.png");
    public static final ResourceLocation LEFT_PAGE_BACK = new ResourceLocation("buildcraftlib:textures/gui/guide/left_page_back.png");
    public static final ResourceLocation RIGHT_PAGE_BACK = new ResourceLocation("buildcraftlib:textures/gui/guide/right_page_back.png");
    public static final ResourceLocation NOTE = new ResourceLocation("buildcraftlib:textures/gui/guide/note.png");
    public static final GuiIcon BOOK_COVER = new GuiIcon(COVER, 0.0, 0.0, 202.0, 248.0);
    public static final GuiIcon BOOK_BINDING = new GuiIcon(COVER, 204.0, 0.0, 11.0, 248.0);
    public static final GuiIcon PAGE_LEFT = new GuiIcon(LEFT_PAGE, 0.0, 0.0, 193.0, 248.0);
    public static final GuiIcon PAGE_RIGHT = new GuiIcon(RIGHT_PAGE, 0.0, 0.0, 193.0, 248.0);
    public static final GuiIcon PAGE_LEFT_BACK = new GuiIcon(LEFT_PAGE_BACK, 0.0, 0.0, 193.0, 248.0);
    public static final GuiIcon PAGE_RIGHT_BACK = new GuiIcon(RIGHT_PAGE_BACK, 0.0, 0.0, 193.0, 248.0);
    public static final GuiRectangle PAGE_LEFT_TEXT = new GuiRectangle(23.0, 25.0, 168.0, 190.0);
    public static final GuiRectangle PAGE_RIGHT_TEXT = new GuiRectangle(4.0, 25.0, 168.0, 190.0);
    public static final GuiIcon PEN_UP = new GuiIcon(ICONS_2, 0.0, 0.0, 14.0, 135.0);
    public static final GuiIcon PEN_ANGLED = new GuiIcon(ICONS_2, 17.0, 0.0, 100.0, 100.0);
    public static final GuiIcon PEN_HIDDEN_MIN = new GuiIcon(ICONS_2, 0.0, 4.0, 10.0, 5.0);
    public static final GuiIcon PEN_HIDDEN_MAX = new GuiIcon(ICONS_2, 0.0, 4.0, 10.0, 15.0);
    public static final GuiIcon TURN_BACK = new GuiIcon(ICONS_2, 23.0, 139.0, 18.0, 10.0);
    public static final GuiIcon TURN_BACK_HOVERED = new GuiIcon(ICONS_2, 23.0, 152.0, 18.0, 10.0);
    public static final GuiIcon TURN_FORWARDS = new GuiIcon(ICONS_2, 0.0, 139.0, 18.0, 10.0);
    public static final GuiIcon TURN_FORWARDS_HOVERED = new GuiIcon(ICONS_2, 0.0, 152.0, 18.0, 10.0);
    public static final GuiIcon BACK = new GuiIcon(ICONS_2, 48.0, 139.0, 17.0, 9.0);
    public static final GuiIcon BACK_HOVERED = new GuiIcon(ICONS_2, 48.0, 152.0, 17.0, 9.0);
    public static final GuiIcon BOX_EMPTY = new GuiIcon(ICONS_2, 0.0, 164.0, 16.0, 16.0);
    public static final GuiIcon BOX_MINUS = new GuiIcon(ICONS_2, 16.0, 164.0, 16.0, 16.0);
    public static final GuiIcon BOX_PLUS = new GuiIcon(ICONS_2, 32.0, 164.0, 16.0, 16.0);
    public static final GuiIcon BOX_TICKED = new GuiIcon(ICONS_2, 48.0, 164.0, 16.0, 16.0);
    public static final GuiIcon BOX_CHAPTER = new GuiIcon(ICONS_2, 64.0, 164.0, 16.0, 16.0);
    public static final GuiIcon BOX_SELECTED_EMPTY = new GuiIcon(ICONS_2, 0.0, 180.0, 16.0, 16.0);
    public static final GuiIcon BOX_SELECTED_MINUS = new GuiIcon(ICONS_2, 16.0, 180.0, 16.0, 16.0);
    public static final GuiIcon BOX_SELECTED_PLUS = new GuiIcon(ICONS_2, 32.0, 180.0, 16.0, 16.0);
    public static final GuiIcon BOX_SELECTED_TICKED = new GuiIcon(ICONS_2, 48.0, 180.0, 16.0, 16.0);
    public static final GuiIcon BOX_SELECTED_CHAPTER = new GuiIcon(ICONS_2, 64.0, 180.0, 16.0, 16.0);
    public static final GuiIcon BORDER_TOP_LEFT = new GuiIcon(ICONS_2, 0.0, 196.0, 13.0, 13.0);
    public static final GuiIcon BORDER_TOP_RIGHT = new GuiIcon(ICONS_2, 13.0, 196.0, 13.0, 13.0);
    public static final GuiIcon BORDER_BOTTOM_LEFT = new GuiIcon(ICONS_2, 0.0, 209.0, 13.0, 13.0);
    public static final GuiIcon BORDER_BOTTOM_RIGHT = new GuiIcon(ICONS_2, 13.0, 209.0, 13.0, 13.0);
    public static final GuiIcon ORDER_TYPE = new GuiIcon(ICONS_2, 14.0, 100.0, 14.0, 14.0);
    public static final GuiIcon ORDER_MOD_TYPE = new GuiIcon(ICONS_2, 42.0, 100.0, 14.0, 14.0);
    public static final GuiIcon ORDER_MOD = new GuiIcon(ICONS_2, 56.0, 100.0, 14.0, 14.0);
    public static final GuiIcon CHAPTER_MARKER_LEFT = new GuiIcon(ICONS_2, 0.0, 223.0, 5.0, 16.0);
    public static final GuiIcon CHAPTER_MARKER_SPACE = new GuiIcon(ICONS_2, 6.0, 223.0, 19.0, 16.0);
    public static final GuiIcon CHAPTER_MARKER_RIGHT = new GuiIcon(ICONS_2, 27.0, 223.0, 5.0, 16.0);
    public static final GuiIcon NOTE_PAGE = new GuiIcon(NOTE, 0.0, 0.0, 131.0, 164.0);
    public static final GuiIcon NOTE_UNDERLAY = new GuiIcon(ICONS_2, 0.0, 1.0, 3.0, 4.0);
    public static final GuiIcon NOTE_OVERLAY = new GuiIcon(ICONS_2, 0.0, 1.0, 2.0, 3.0);
    public static final GuiIcon SEARCH_ICON = new GuiIcon(ICONS_2, 26.0, 196.0, 12.0, 12.0);
    public static final GuiIcon SEARCH_TAB_CLOSED = new GuiIcon(ICONS_2, 58.0, 196.0, 14.0, 6.0);
    public static final GuiIcon SEARCH_TAB_OPEN = new GuiIcon(ICONS_2, 40.0, 209.0, 106.0, 14.0);
    public static final GuiIcon[] ORDERS = new GuiIcon[]{ORDER_TYPE, ORDER_MOD_TYPE, ORDER_MOD};
    public static final GuiRectangle BACK_POSITION = new GuiRectangle(GuiGuide.PAGE_LEFT.width - GuiGuide.BACK.width / 2, GuiGuide.PAGE_LEFT.height - GuiGuide.BACK.height - 2, GuiGuide.BACK.width, GuiGuide.BACK.height);
    public static final TypeOrder[] SORTING_TYPES = new TypeOrder[]{new TypeOrder(ETypeTag.TYPE, ETypeTag.SUB_TYPE), new TypeOrder(ETypeTag.MOD, ETypeTag.TYPE), new TypeOrder(ETypeTag.MOD, ETypeTag.SUB_MOD)};
    private static final int PEN_HIDDEN_Y = 0;
    private static final int PEN_HIDDEN_X = 4;
    private static final int PEN_HIDDEN_WIDTH = 10;
    private static final int PEN_HIDDEN_HEIGHT_MIN = 5;
    private static final int PEN_HIDDEN_HEIGHT_MAX = 15;
    public static final GuiRectangle PEN_HIDDEN_AREA = new GuiRectangle(GuiGuide.PAGE_LEFT.width - 5, -15.0, 10.0, 15.0);
    private static final float PEN_HOVER_TIME = 9.0f;
    private static final float BOOK_OPEN_TIME = 10.0f;
    public final MousePosition mouse = new MousePosition();
    public int sortingOrderIndex = 0;
    private boolean isOpen = false;
    private boolean isEditing = false;
    private boolean isOpening = false;
    private float openingAngleLast = -90.0f;
    private float openingAngleNext = -90.0f;
    private float hoverStageLast = 0.0f;
    private float hoverStageNext = 0.0f;
    private boolean isOverHover = false;
    public int minX;
    public int minY;
    public ItemStack tooltipStack = null;
    public final List<String> tooltip = new ArrayList<String>();
    private final Deque<GuidePageBase> pages = Queues.newArrayDeque();
    private final List<GuideChapter> chapters = new ArrayList<GuideChapter>();
    private GuidePageBase currentPage;
    private IFontRenderer currentFont = FontManager.INSTANCE.getOrLoadFont("SansSerif", 9);
    private float lastPartialTicks;

    public GuiGuide() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.openPage(new GuidePageContents(this));
    }

    public GuiGuide(String noteId) {
        this.field_146297_k = Minecraft.func_71410_x();
    }

    public void initForExport() {
        this.isOpening = true;
        this.isOpen = true;
        this.func_146280_a(Minecraft.func_71410_x(), 1920, 1080);
    }

    public void openPage(GuidePageBase page) {
        if (this.currentPage != null && this.currentPage.shouldPersistHistory()) {
            this.pages.push(this.currentPage);
        }
        this.setPageInternal(page);
    }

    public void closePage() {
        if (this.pages.isEmpty()) {
            this.field_146297_k.func_147108_a(null);
        } else {
            this.setPageInternal(this.pages.pop());
        }
    }

    public void goBackToMenu() {
        GuidePageBase newPage = this.currentPage;
        while (!this.pages.isEmpty()) {
            newPage = this.pages.pop();
        }
        this.setPageInternal(newPage);
    }

    private void setPageInternal(GuidePageBase page) {
        this.currentPage = page;
        this.refreshChapters();
    }

    public GuidePageBase getCurrentPage() {
        return this.currentPage;
    }

    public IFontRenderer getCurrentFont() {
        return this.currentFont;
    }

    public int getChapterIndex(GuideChapter chapter) {
        return this.chapters.indexOf(chapter);
    }

    public void refreshChapters() {
        this.chapters.clear();
        this.chapters.addAll(this.currentPage.getChapters());
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.isOpen) {
            float hoverDiff = 1.1111112f;
            this.hoverStageLast = this.hoverStageNext;
            if (this.hoverStageNext > 15.0f) {
                this.hoverStageNext -= hoverDiff * 5.0f;
            } else if (this.isOverHover) {
                this.hoverStageNext += hoverDiff;
                if (this.hoverStageNext > 15.0f) {
                    this.hoverStageNext = 15.0f;
                }
            } else {
                if (this.hoverStageNext > 5.0f) {
                    this.hoverStageNext -= hoverDiff;
                }
                if (this.hoverStageNext < 5.0f) {
                    this.hoverStageNext = 5.0f;
                }
            }
            this.currentPage.updateScreen();
            for (GuideChapter chapter : this.chapters) {
                chapter.updateScreen();
            }
        } else if (this.isOpening) {
            this.openingAngleLast = this.openingAngleNext;
            this.openingAngleNext += 18.0f;
        }
        if (this.currentPage != null) {
            this.setupFontRenderer();
            this.currentPage.tick();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.lastPartialTicks = partialTicks = this.field_146297_k.func_184121_ak();
        this.minX = (this.field_146294_l - GuiGuide.PAGE_LEFT.width * 2) / 2;
        this.minY = (this.field_146295_m - GuiGuide.BOOK_COVER.height) / 2;
        this.mouse.setMousePosition(mouseX, mouseY);
        try {
            if (this.isOpen) {
                this.drawOpen(partialTicks);
            } else if (this.isOpening) {
                this.drawOpening(partialTicks);
            } else {
                this.drawCover();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public float getLastPartialTicks() {
        return this.lastPartialTicks;
    }

    public void drawTooltip(ItemStack stack, int x, int y) {
        this.func_146285_a(stack, x, y);
    }

    private void drawCover() {
        this.minX = (this.field_146294_l - GuiGuide.BOOK_COVER.width) / 2;
        this.minY = (this.field_146295_m - GuiGuide.BOOK_COVER.height) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(COVER);
        BOOK_COVER.drawAt(this.minX, this.minY);
    }

    private void drawOpening(float partialTicks) {
        this.minX = (this.field_146294_l - GuiGuide.BOOK_COVER.width) / 2;
        this.minY = (this.field_146295_m - GuiGuide.BOOK_COVER.height) / 2;
        float openingAngle = this.openingAngleLast * (1.0f - partialTicks) + this.openingAngleNext * partialTicks;
        float sin = MathHelper.func_76126_a((float)((float)((double)openingAngle * Math.PI / 180.0)));
        if (sin < 0.0f) {
            sin *= -1.0f;
        }
        if (openingAngle >= 90.0f) {
            this.isOpen = true;
        }
        if (openingAngle < 0.0f) {
            this.minX = (this.field_146294_l - GuiGuide.BOOK_COVER.width) / 2;
            this.minY = (this.field_146295_m - GuiGuide.BOOK_COVER.height) / 2;
            int coverWidth = (int)(sin * (float)GuiGuide.BOOK_COVER.width);
            sin = 1.0f - sin;
            float offset = sin * 50.0f;
            int bindingWidth = (int)(sin * (float)GuiGuide.BOOK_BINDING.width);
            this.field_146297_k.field_71446_o.func_110577_a(RIGHT_PAGE);
            PAGE_RIGHT.drawAt(this.minX + GuiGuide.BOOK_COVER.width - GuiGuide.PAGE_RIGHT.width, this.minY);
            this.field_146297_k.field_71446_o.func_110577_a(COVER);
            BOOK_COVER.drawCustomQuad(this.minX, this.minY + GuiGuide.BOOK_COVER.height, this.minX + coverWidth, (float)(this.minY + GuiGuide.BOOK_COVER.height) + offset, this.minX + coverWidth, (float)this.minY - offset, this.minX, this.minY);
            BOOK_BINDING.drawScaledInside((int)((double)(this.minX + coverWidth) - (double)bindingWidth * 0.5), (int)((float)this.minY - offset), bindingWidth, (int)((float)GuiGuide.BOOK_BINDING.height + offset * 2.0f));
        } else if (openingAngle == 0.0f) {
            this.minX = (this.field_146294_l - GuiGuide.BOOK_COVER.width) / 2;
            this.minY = (this.field_146295_m - GuiGuide.BOOK_COVER.height) / 2;
            this.field_146297_k.field_71446_o.func_110577_a(RIGHT_PAGE);
            PAGE_RIGHT.drawAt(this.minX + GuiGuide.BOOK_COVER.width - GuiGuide.PAGE_LEFT.width, this.minY);
            this.field_146297_k.field_71446_o.func_110577_a(COVER);
            BOOK_COVER.drawAt(this.minX, this.minY);
        } else if (openingAngle > 0.0f) {
            int pageWidth = (int)(sin * (float)GuiGuide.PAGE_LEFT.width);
            int bindingWidth = (int)((1.0f - sin) * (float)GuiGuide.BOOK_BINDING.width);
            int penHeight = (int)(sin * 5.0f);
            float offset = (1.0f - sin) * 50.0f;
            this.minX = (this.field_146294_l - GuiGuide.PAGE_LEFT.width - pageWidth) / 2;
            this.minY = (this.field_146295_m - GuiGuide.BOOK_COVER.height) / 2;
            this.field_146297_k.field_71446_o.func_110577_a(RIGHT_PAGE);
            PAGE_RIGHT.drawAt(this.minX + pageWidth + bindingWidth, this.minY);
            this.field_146297_k.field_71446_o.func_110577_a(LEFT_PAGE);
            PAGE_LEFT.drawCustomQuad(this.minX + bindingWidth, (float)(this.minY + GuiGuide.PAGE_LEFT.height) + offset, this.minX + bindingWidth + pageWidth, this.minY + GuiGuide.PAGE_LEFT.height, this.minX + bindingWidth + pageWidth, this.minY, this.minX + bindingWidth, (float)this.minY - offset);
            this.field_146297_k.field_71446_o.func_110577_a(COVER);
            BOOK_BINDING.drawScaledInside((int)((double)this.minX + (double)bindingWidth * 0.5), (int)((float)this.minY - offset), bindingWidth, (int)((float)GuiGuide.BOOK_BINDING.height + offset * 2.0f));
            this.field_146297_k.field_71446_o.func_110577_a(ICONS_2);
            this.func_73729_b(this.minX + pageWidth + bindingWidth - 5, this.minY - penHeight, 4, 0, 10, penHeight);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawOpen(float partialTicks) {
        this.field_146297_k.field_71446_o.func_110577_a(LEFT_PAGE);
        PAGE_LEFT.drawAt(this.minX, this.minY);
        this.field_146297_k.field_71446_o.func_110577_a(RIGHT_PAGE);
        PAGE_RIGHT.drawAt(this.minX + GuiGuide.PAGE_LEFT.width, this.minY);
        this.isOverHover = PEN_HIDDEN_AREA.offset((double)this.minX, (double)this.minY).contains(this.mouse);
        String title = this.currentPage.getTitle();
        if (title != null) {
            int x = (this.field_146294_l - this.currentFont.getStringWidth(title)) / 2;
            this.currentFont.drawString(title, x, this.minY + 12, 0);
        }
        this.tooltipStack = null;
        this.tooltip.clear();
        this.setupFontRenderer();
        for (GuideChapter guideChapter : this.chapters) {
            guideChapter.reset();
        }
        this.currentPage.renderFirstPage(this.minX + (int)GuiGuide.PAGE_LEFT_TEXT.x, this.minY + (int)GuiGuide.PAGE_LEFT_TEXT.y, (int)GuiGuide.PAGE_LEFT_TEXT.width, (int)GuiGuide.PAGE_LEFT_TEXT.height);
        this.currentPage.renderSecondPage(this.minX + GuiGuide.PAGE_LEFT.width + (int)GuiGuide.PAGE_RIGHT_TEXT.x, this.minY + (int)GuiGuide.PAGE_RIGHT_TEXT.y, (int)GuiGuide.PAGE_RIGHT_TEXT.width, (int)GuiGuide.PAGE_RIGHT_TEXT.height);
        int chapterIndex = 0;
        for (GuideChapter chapter : this.chapters) {
            chapter.draw(chapterIndex, partialTicks);
            ++chapterIndex;
        }
        if (!this.pages.isEmpty()) {
            void var4_10;
            GuiIcon guiIcon = BACK;
            GuiRectangle position = BACK_POSITION.offset((double)this.minX, (double)this.minY);
            if (position.contains(this.mouse)) {
                GuiIcon guiIcon2 = BACK_HOVERED;
            }
            var4_10.drawAt(position);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isEditing) {
            this.field_146297_k.field_71446_o.func_110577_a(ICONS_2);
            if (this.isOverHover) {
                PEN_UP.drawAt(this.mouse.getX() - (double)(GuiGuide.PEN_UP.width / 2), this.mouse.getY() - (double)GuiGuide.PEN_UP.height);
            } else {
                PEN_ANGLED.drawAt(this.mouse.getX() - 2.0, this.mouse.getY() - (double)GuiGuide.PEN_ANGLED.height - 2.0);
            }
        } else {
            int n = (int)(this.hoverStageLast * (1.0f - partialTicks) + this.hoverStageNext * partialTicks);
            this.field_146297_k.field_71446_o.func_110577_a(ICONS_2);
            this.func_73729_b(this.minX + GuiGuide.PAGE_LEFT.width - 5, this.minY - n, 4, 0, 10, n);
            if (this.tooltipStack != null) {
                this.func_146285_a(this.tooltipStack, (int)this.mouse.getX(), (int)this.mouse.getY());
            } else if (!this.tooltip.isEmpty()) {
                this.func_146283_a(this.tooltip, (int)this.mouse.getX(), (int)this.mouse.getY());
            }
        }
    }

    public void setupFontRenderer() {
        this.currentPage.setFontRenderer(this.currentFont);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.mouse.setMousePosition(mouseX, mouseY);
        if (mouseButton == 0) {
            if (this.isOpen) {
                int page0xMin = this.minX + (int)GuiGuide.PAGE_LEFT_TEXT.x;
                int page0xMax = page0xMin + (int)GuiGuide.PAGE_LEFT_TEXT.width;
                int page1xMin = this.minX + GuiGuide.PAGE_LEFT.width + (int)GuiGuide.PAGE_RIGHT_TEXT.x;
                int page1xMax = page1xMin + (int)GuiGuide.PAGE_RIGHT_TEXT.width;
                int pageYMin = this.minY + (int)GuiGuide.PAGE_RIGHT_TEXT.y;
                int pageYMax = pageYMin + (int)GuiGuide.PAGE_RIGHT_TEXT.height;
                GuidePageBase current = this.currentPage;
                current.setFontRenderer(this.currentFont);
                for (GuideChapter chapter : this.chapters) {
                    if (!chapter.handleClick()) continue;
                    return;
                }
                current.handleMouseClick(page0xMin, pageYMin, page0xMax - page0xMin, pageYMax - pageYMin, mouseX, mouseY, mouseButton, this.currentPage.getPage(), this.isEditing);
                current.handleMouseClick(page1xMin, pageYMin, page1xMax - page1xMin, pageYMax - pageYMin, mouseX, mouseY, mouseButton, this.currentPage.getPage() + 1, this.isEditing);
                if (!this.pages.isEmpty() && BACK_POSITION.offset((double)this.minX, (double)this.minY).contains(this.mouse)) {
                    this.closePage();
                }
                if (this.isOverHover) {
                    boolean bl = this.isEditing = !this.isEditing;
                    if (!this.isEditing) {
                        this.hoverStageNext = GuiGuide.PEN_UP.height;
                    }
                }
            } else if (mouseX >= this.minX && mouseY >= this.minY && mouseX <= this.minX + GuiGuide.BOOK_COVER.width && mouseY <= this.minY + GuiGuide.BOOK_COVER.height) {
                if (this.isOpening) {
                    this.isOpen = true;
                }
                this.isOpening = true;
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.currentPage.keyTyped(typedChar, keyCode)) {
            return;
        }
        if (keyCode == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.currentPage.lastPage();
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.currentPage.nextPage();
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

