/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.chunkload;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLib;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.chunkload.IChunkLoadingTile;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.WorldPos;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderManager {
    private static final Map<WorldPos, ForgeChunkManager.Ticket> TICKETS = new HashMap<WorldPos, ForgeChunkManager.Ticket>();

    public static <T extends TileEntity> void loadChunksForTile(@Nonnull T tile) {
        if (TICKETS.containsKey(new WorldPos(tile))) {
            ChunkLoaderManager.updateChunksFor(tile);
            return;
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)BCLib.INSTANCE, (World)tile.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            BCLog.logger.warn("Chunkloading failed, most likely the limit was reached");
            return;
        }
        if (!ChunkLoaderManager.canLoadFor((IChunkLoadingTile)tile)) {
            return;
        }
        ticket.getModData().func_74782_a("location", (NBTBase)NBTUtilBC.writeBlockPos(tile.func_174877_v()));
        for (ChunkPos chunkPos : ChunkLoaderManager.getChunksToLoad(tile)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        }
        TICKETS.put(new WorldPos(tile), ticket);
    }

    public static <T extends TileEntity> void releaseChunksFor(@Nonnull T tile) {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)TICKETS.get(new WorldPos(tile)));
        TICKETS.remove(new WorldPos(tile));
    }

    private static <T extends TileEntity> void updateChunksFor(@Nonnull T tile) {
        if (!TICKETS.containsKey(new WorldPos(tile))) {
            ChunkLoaderManager.loadChunksForTile(tile);
        }
        ForgeChunkManager.Ticket ticket = TICKETS.get(new WorldPos(tile));
        Set<ChunkPos> chunks = ChunkLoaderManager.getChunksToLoad(tile);
        for (ChunkPos pos : ticket.getChunkList()) {
            if (chunks.contains(pos)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
        for (ChunkPos pos : chunks) {
            if (ticket.getChunkList().contains((Object)pos)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
    }

    public static <T extends TileEntity> Set<ChunkPos> getChunksToLoad(@Nonnull T tile) {
        Set<ChunkPos> chunksToLoad = ((IChunkLoadingTile)tile).getChunksToLoad();
        HashSet<ChunkPos> chunkPoses = new HashSet<ChunkPos>(chunksToLoad != null ? chunksToLoad : Collections.emptyList());
        chunkPoses.add(new ChunkPos(tile.func_174877_v()));
        return chunkPoses;
    }

    public static void rebindTickets(List<ForgeChunkManager.Ticket> tickets, World world) {
        TICKETS.clear();
        if (BCLibConfig.chunkLoadingLevel != BCLibConfig.ChunkLoaderLevel.NONE) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                BlockPos pos = NBTUtilBC.readBlockPos(ticket.getModData().func_74781_a("location"));
                if (pos == null) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    continue;
                }
                if (TICKETS.containsKey(new WorldPos(world, pos))) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    continue;
                }
                TICKETS.put(new WorldPos(world, pos), ticket);
                TileEntity tile = world.func_175625_s(pos);
                if (tile == null || !(tile instanceof IChunkLoadingTile) || !ChunkLoaderManager.canLoadFor((IChunkLoadingTile)tile)) {
                    TICKETS.remove(new WorldPos(world, pos));
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    continue;
                }
                for (ChunkPos chunkPos : ChunkLoaderManager.getChunksToLoad((TileEntity)((IChunkLoadingTile)tile))) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
                }
            }
        }
    }

    private static boolean canLoadFor(IChunkLoadingTile tile) {
        return BCLibConfig.chunkLoadingLevel.canLoad(tile.getLoadType());
    }
}

