/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.block;

import buildcraft.api.blocks.CustomRotationHelper;
import buildcraft.lib.misc.collect.OrderedEnumMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VanillaRotationHandlers {
    public static final OrderedEnumMap<EnumFacing> ROTATE_HORIZONTAL;
    public static final OrderedEnumMap<EnumFacing> ROTATE_FACING;
    public static final OrderedEnumMap<EnumFacing> ROTATE_TORCH;
    public static final OrderedEnumMap<BlockLever.EnumOrientation> ROTATE_LEVER;

    public static void fmlInit() {
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockButton.class, VanillaRotationHandlers::rotateButton);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockDoor.class, VanillaRotationHandlers::rotateDoor);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockPistonBase.class, VanillaRotationHandlers::rotatePiston);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockLever.class, VanillaRotationHandlers::rotateLever);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockFenceGate.class, VanillaRotationHandlers::rotateGate);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockRedstoneDiode.class, VanillaRotationHandlers::rotateDiode);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockTorch.class, VanillaRotationHandlers::rotateTorch);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockChest.class, VanillaRotationHandlers::rotateChest);
    }

    public static <T> int getOrdinal(T side, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (side != array[i]) continue;
            return i;
        }
        return 0;
    }

    private static EnumActionResult rotateDoor(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockDoor) {
            BlockDoor.EnumDoorHalf half = (BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O);
            if (half == BlockDoor.EnumDoorHalf.UPPER) {
                BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)state.func_177229_b((IProperty)BlockDoor.field_176521_M);
                hinge = hinge == BlockDoor.EnumHingePosition.LEFT ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT;
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge));
            } else {
                VanillaRotationHandlers.rotateOnce(world, pos, state, BlockDoor.field_176520_a, ROTATE_HORIZONTAL);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateButton(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockButton) {
            PropertyDirection prop = BlockDirectional.field_176387_N;
            return VanillaRotationHandlers.rotateEnumFacing(world, pos, state, (IProperty<EnumFacing>)prop, ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotatePiston(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockPistonBase) {
            boolean extended = (Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b);
            if (extended) {
                return EnumActionResult.FAIL;
            }
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockDirectional.field_176387_N, ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateLever(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockLever) {
            return VanillaRotationHandlers.rotateAnyTypeAuto(world, pos, state, BlockLever.field_176360_a, ROTATE_LEVER, BlockLever.EnumOrientation::func_176852_c);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateGate(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockFenceGate) {
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockFenceGate.field_185512_D, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateDiode(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockRedstoneDiode) {
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockRedstoneDiode.field_185512_D, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateTorch(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockTorch) {
            PropertyDirection prop = BlockTorch.field_176596_a;
            Predicate<EnumFacing> tester = toTry -> world.isSideSolid(pos.func_177972_a(toTry.func_176734_d()), toTry);
            return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, prop, ROTATE_TORCH, tester);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateChest(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        return EnumActionResult.PASS;
    }

    public static EnumActionResult rotateEnumFacing(World world, BlockPos pos, IBlockState state, IProperty<EnumFacing> prop, OrderedEnumMap<EnumFacing> possible) {
        return VanillaRotationHandlers.rotateAnyTypeAuto(world, pos, state, prop, possible, f -> f);
    }

    public static <E extends Enum<E>> EnumActionResult rotateOnce(World world, BlockPos pos, IBlockState state, IProperty<E> prop, OrderedEnumMap<E> possible) {
        Enum current = (Enum)((Object)state.func_177229_b(prop));
        current = possible.next(current);
        world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((Object)current)));
        return EnumActionResult.SUCCESS;
    }

    public static <E extends Enum<E>> EnumActionResult rotateAnyTypeAuto(World world, BlockPos pos, IBlockState state, IProperty<E> prop, OrderedEnumMap<E> possible, Function<E, EnumFacing> mapper) {
        Predicate<Enum> tester = toTry -> state.func_177230_c().func_176198_a(world, pos, (EnumFacing)mapper.apply(toTry));
        return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, prop, possible, tester);
    }

    public static <E extends Enum<E>> EnumActionResult rotateAnyTypeManual(World world, BlockPos pos, IBlockState state, IProperty<E> prop, OrderedEnumMap<E> possible, Predicate<E> canPlace) {
        Enum current = (Enum)((Object)state.func_177229_b(prop));
        for (int i = possible.getOrderLength(); i > 1; --i) {
            if (!canPlace.test(current = possible.next(current))) continue;
            world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((Object)current)));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    static {
        EnumFacing e = EnumFacing.EAST;
        EnumFacing w = EnumFacing.WEST;
        EnumFacing u = EnumFacing.UP;
        EnumFacing d = EnumFacing.DOWN;
        EnumFacing n = EnumFacing.NORTH;
        EnumFacing s = EnumFacing.SOUTH;
        ROTATE_HORIZONTAL = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, w, n});
        ROTATE_FACING = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, d, w, n, u});
        ROTATE_TORCH = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, w, n, u});
        BlockLever.EnumOrientation[] leverFaces = new BlockLever.EnumOrientation[8];
        int index = 0;
        for (EnumFacing face : (EnumFacing[])ROTATE_FACING.getOrder()) {
            if (face == EnumFacing.DOWN) {
                leverFaces[index++] = BlockLever.EnumOrientation.DOWN_Z;
                leverFaces[index++] = BlockLever.EnumOrientation.DOWN_X;
                continue;
            }
            if (face == EnumFacing.UP) {
                leverFaces[index++] = BlockLever.EnumOrientation.UP_Z;
                leverFaces[index++] = BlockLever.EnumOrientation.UP_X;
                continue;
            }
            leverFaces[index++] = BlockLever.EnumOrientation.func_176856_a((EnumFacing)face, null);
        }
        ROTATE_LEVER = new OrderedEnumMap(BlockLever.EnumOrientation.class, (Enum[])leverFaces);
    }
}

