/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib;

import buildcraft.api.BCModules;
import buildcraft.api.IBuildCraftMod;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.reload.LibConfigChangeListener;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.client.render.MarkerRenderer;
import buildcraft.lib.debug.DebugRenderHelper;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.net.MessageContainer;
import buildcraft.lib.net.MessageDebugRequest;
import buildcraft.lib.net.MessageDebugResponse;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageMarker;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.cache.MessageObjectCacheRequest;
import buildcraft.lib.net.cache.MessageObjectCacheResponse;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCLibProxy
implements IGuiHandler {
    @SidedProxy(modId="buildcraftlib")
    private static BCLibProxy proxy;

    public static BCLibProxy getProxy() {
        return proxy;
    }

    void fmlPreInit() {
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageUpdateTile.class, MessageUpdateTile.HANDLER, new Side[0]);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageContainer.class, MessageContainer.HANDLER, new Side[0]);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageMarker.class, Side.CLIENT);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageObjectCacheRequest.class, MessageObjectCacheRequest.HANDLER, Side.SERVER);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageObjectCacheResponse.class, Side.CLIENT);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageDebugRequest.class, MessageDebugRequest.HANDLER, Side.SERVER);
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.LIB, MessageDebugResponse.class, Side.CLIENT);
    }

    void fmlInit() {
    }

    void fmlPostInit() {
    }

    public World getClientWorld() {
        return null;
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public EntityPlayer getPlayerForContext(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public void addScheduledTask(World world, Runnable task) {
        if (world instanceof WorldServer) {
            WorldServer server = (WorldServer)world;
            server.func_152344_a(task);
        }
    }

    public <T extends TileEntity> T getServerTile(T tile) {
        return tile;
    }

    public InputStream getStreamForIdentifier(ResourceLocation identifier) throws IOException {
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCLibProxy {
        @Override
        void fmlPreInit() {
            super.fmlPreInit();
            DetachedRenderer.INSTANCE.addRenderer(DetachedRenderer.RenderMatrixType.FROM_WORLD_ORIGIN, MarkerRenderer.INSTANCE);
            DetachedRenderer.INSTANCE.addRenderer(DetachedRenderer.RenderMatrixType.FROM_WORLD_ORIGIN, DebugRenderHelper.INSTANCE);
            BCLibSprites.fmlPreInitClient();
            BCLibConfig.configChangeListeners.add(LibConfigChangeListener.INSTANCE);
            MessageManager.setHandler(MessageMarker.class, MessageMarker.HANDLER, Side.CLIENT);
            MessageManager.setHandler(MessageObjectCacheResponse.class, MessageObjectCacheResponse.HANDLER, Side.CLIENT);
            MessageManager.setHandler(MessageDebugResponse.class, MessageDebugResponse.HANDLER, Side.CLIENT);
        }

        @Override
        void fmlInit() {
            super.fmlInit();
        }

        @Override
        void fmlPostInit() {
            super.fmlPostInit();
            IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
            IReloadableResourceManager reloadable = (IReloadableResourceManager)manager;
            reloadable.func_110542_a((IResourceManagerReloadListener)GuideManager.INSTANCE);
            GuiConfigManager.loadFromConfigFile();
        }

        @Override
        public World getClientWorld() {
            return Minecraft.func_71410_x().field_71441_e;
        }

        @Override
        public EntityPlayer getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        @Override
        public EntityPlayer getPlayerForContext(MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                return super.getPlayerForContext(ctx);
            }
            return this.getClientPlayer();
        }

        @Override
        public void addScheduledTask(World world, Runnable task) {
            if (world instanceof WorldClient) {
                Minecraft.func_71410_x().func_152344_a(task);
            } else {
                super.addScheduledTask(world, task);
            }
        }

        @Override
        public <T extends TileEntity> T getServerTile(T tile) {
            if (tile != null && tile.func_145830_o()) {
                World world = tile.func_145831_w();
                if (world.field_72995_K && Minecraft.func_71410_x().func_71356_B()) {
                    WorldServer server = DimensionManager.getWorld((int)world.field_73011_w.getDimension());
                    if (server == null) {
                        return tile;
                    }
                    TileEntity atServer = server.func_175625_s(tile.func_174877_v());
                    if (atServer == null) {
                        return tile;
                    }
                    if (atServer.getClass() == tile.getClass()) {
                        return (T)atServer;
                    }
                }
            }
            return tile;
        }

        @Override
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            if (id == 0) {
                return new GuiGuide();
            }
            return null;
        }

        @Override
        public InputStream getStreamForIdentifier(ResourceLocation identifier) throws IOException {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(identifier).func_110527_b();
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCLibProxy {
    }
}

