/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.craft.IAutoCraft;
import buildcraft.lib.tile.craft.WorkbenchCrafting;
import buildcraft.lib.tile.item.ItemHandlerFiltered;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileAutoWorkbenchBase
extends TileBC_Neptune
implements ITickable,
IHasWork,
IMjRedstoneReceiver,
IAutoCraft {
    private static final long POWER_GEN_PASSIVE = MjAPI.MJ / 5L;
    private static final long POWER_REQUIRED = POWER_GEN_PASSIVE * 20L * 10L;
    private static final long POWER_LOST = POWER_GEN_PASSIVE * 10L;
    public final ItemHandlerSimple invBlueprint;
    public final ItemHandlerSimple invMaterialFilter;
    public final ItemHandlerFiltered invMaterials;
    public final ItemHandlerSimple invResult;
    private final WorkbenchCrafting crafting;
    private long powerStored;
    private long powerStoredLast;
    public ItemStack resultClient = ItemStack.field_190927_a;

    public TileAutoWorkbenchBase(int width, int height) {
        int slots = width * height;
        this.invBlueprint = this.itemManager.addInvHandler("blueprint", slots, ItemHandlerManager.EnumAccess.PHANTOM, new EnumPipePart[0]);
        this.invMaterialFilter = this.itemManager.addInvHandler("material_filter", slots, ItemHandlerManager.EnumAccess.PHANTOM, new EnumPipePart[0]);
        this.invMaterials = new ItemHandlerFiltered(this.invMaterialFilter, true);
        this.invMaterials.setCallback(this.itemManager.callback);
        this.itemManager.addInvHandler("materials", this.invMaterials, ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.invResult = this.itemManager.addInvHandler("result", 1, ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.crafting = new WorkbenchCrafting(width, height, this, this.invBlueprint, this.invMaterials, this.invResult);
        this.caps.addCapabilityInstance(TilesAPI.CAP_HAS_WORK, this, EnumPipePart.VALUES);
        this.caps.addProvider(new MjCapabilityHelper(this));
    }

    @Override
    protected void onSlotChange(IItemHandlerModifiable handler, int slot, @Nonnull ItemStack before, @Nonnull ItemStack after) {
        if (!ItemStack.func_77989_b((ItemStack)before, (ItemStack)after)) {
            this.crafting.onInventoryChange((IItemHandler)handler);
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean didChange = this.crafting.tick();
        if (this.crafting.canCraft()) {
            if (this.powerStored >= POWER_REQUIRED) {
                if (this.crafting.craft()) {
                    this.powerStored = this.crafting.canCraft() ? 1L : 0L;
                }
            } else {
                this.powerStored += POWER_GEN_PASSIVE;
            }
        } else {
            this.powerStored = this.powerStored >= POWER_LOST ? (this.powerStored -= POWER_LOST) : 0L;
        }
        if (didChange) {
            this.createFilters();
            this.sendNetworkGuiUpdate(NET_GUI_DATA);
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_GUI_TICK) {
                buffer.writeLong(this.powerStored);
            } else if (id == NET_GUI_DATA) {
                buffer.func_150788_a(this.crafting.getAssumedResult());
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_GUI_TICK) {
                this.powerStoredLast = this.powerStored;
                this.powerStored = buffer.readLong();
                if (this.powerStored < 10L) {
                    this.powerStoredLast = this.powerStored;
                }
            } else if (id == NET_GUI_DATA) {
                this.resultClient = buffer.func_150791_c();
            }
        }
    }

    @Override
    public boolean hasWork() {
        return this.powerStored > 0L;
    }

    public double getProgress(float partialTicks) {
        return MathUtil.interp(partialTicks, this.powerStoredLast, this.powerStored) / (double)POWER_REQUIRED;
    }

    public InventoryCrafting getWorkbenchCrafting() {
        return this.crafting;
    }

    private void createFilters() {
        int i;
        if (this.crafting.getAssumedResult().func_190926_b()) {
            for (int s = 0; s < this.invMaterialFilter.getSlots(); ++s) {
                this.invMaterialFilter.setStackInSlot(s, ItemStack.field_190927_a);
            }
            return;
        }
        NonNullList uniqueStacks = NonNullList.func_191196_a();
        int slotCount = this.invBlueprint.getSlots();
        int[] requirements = new int[slotCount];
        for (int s = 0; s < slotCount; ++s) {
            ItemStack bptStack = this.invBlueprint.getStackInSlot(s);
            if (bptStack.func_190926_b()) continue;
            boolean foundMatch = false;
            for (i = 0; i < uniqueStacks.size(); ++i) {
                if (!StackUtil.canMerge(bptStack, (ItemStack)uniqueStacks.get(i))) continue;
                foundMatch = true;
                int n = i;
                requirements[n] = requirements[n] + 1;
                break;
            }
            if (foundMatch) continue;
            requirements[uniqueStacks.size()] = 1;
            uniqueStacks.add((Object)bptStack);
        }
        int uniqueSlotCount = uniqueStacks.size();
        int[] slotAllocationCount = new int[uniqueSlotCount];
        Arrays.fill(slotAllocationCount, 1);
        int slotsLeft = slotCount - uniqueSlotCount;
        for (i = 0; i < slotsLeft; ++i) {
            int smallestDifference = Integer.MAX_VALUE;
            int smallestDifferenceIndex = 0;
            for (int s = 0; s < uniqueSlotCount; ++s) {
                ItemStack stack = (ItemStack)uniqueStacks.get(s);
                int uniqueCountTotal = stack.func_77976_d() * slotAllocationCount[s];
                int difference = uniqueCountTotal / requirements[s];
                if (difference >= smallestDifference) continue;
                smallestDifference = difference;
                smallestDifferenceIndex = s;
            }
            int n = smallestDifferenceIndex;
            slotAllocationCount[n] = slotAllocationCount[n] + 1;
        }
        int realIndex = 0;
        for (int s = 0; s < uniqueSlotCount; ++s) {
            ItemStack stack = ((ItemStack)uniqueStacks.get(s)).func_77946_l();
            stack.func_190920_e(1);
            for (int i2 = 0; i2 < slotAllocationCount[s]; ++i2) {
                this.invMaterialFilter.setStackInSlot(realIndex, stack);
                ++realIndex;
            }
        }
        if (realIndex != slotCount) {
            throw new IllegalStateException("Somehow the balanced formula wasn't perfectly balanced!");
        }
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        return POWER_REQUIRED - this.powerStored;
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        long req = this.getPowerRequested();
        long taken = Math.min(req, microJoules);
        if (!simulate) {
            this.powerStored += taken;
        }
        return microJoules - taken;
    }

    @Override
    public ItemStack getCurrentRecipeOutput() {
        return this.crafting.getAssumedResult();
    }

    @Override
    public ItemHandlerSimple getInvBlueprint() {
        return this.invBlueprint;
    }
}

