/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.block;

import buildcraft.factory.BCFactoryItems;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.SoundUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlockWaterGel
extends BlockBCBase_Neptune {
    public static final PropertyEnum<GelStage> PROP_STAGE = PropertyEnum.func_177709_a((String)"stage", GelStage.class);

    public BlockWaterGel(Material material, String id) {
        super(material, id);
        this.func_149672_a(SoundType.field_185859_l);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROP_STAGE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PROP_STAGE, (Comparable)((Object)GelStage.fromMeta(meta & 7)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((GelStage)((Object)state.func_177229_b(PROP_STAGE))).getMeta();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        GelStage stage = (GelStage)((Object)state.func_177229_b(PROP_STAGE));
        GelStage next = stage.next();
        IBlockState nextState = state.func_177226_a(PROP_STAGE, (Comparable)((Object)next));
        if (stage.spreading) {
            int time;
            ArrayList<BlockPos> openSet = new ArrayList<BlockPos>();
            HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
            ArrayList<BlockPos> changeable = new ArrayList<BlockPos>();
            ArrayList faces = new ArrayList();
            Collections.addAll(faces, EnumFacing.field_82609_l);
            Collections.shuffle(faces);
            for (EnumFacing face : faces) {
                openSet.add(pos.func_177972_a(face));
            }
            Collections.shuffle(faces);
            for (int tries = 0; openSet.size() > 0 && changeable.size() < 3 && tries < 10000; ++tries) {
                boolean spreadable;
                openSet.sort(Comparator.comparingDouble(a -> a.func_177951_i((Vec3i)pos)));
                BlockPos test = (BlockPos)openSet.remove(0);
                closedSet.add(test);
                boolean water = BlockWaterGel.isWater(world, test);
                boolean bl = spreadable = water || this.canSpread(world, test);
                if (water && (Integer)world.func_180495_p(test).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    changeable.add(test);
                }
                if (!spreadable) continue;
                Collections.shuffle(faces);
                for (EnumFacing face : faces) {
                    BlockPos n = test.func_177972_a(face);
                    if (closedSet.contains(n) || openSet.contains(n)) continue;
                    openSet.add(n);
                }
            }
            int n = time = next.spreading ? 200 : 400;
            if (changeable.size() == 3 || world.field_73012_v.nextDouble() < 0.5) {
                for (BlockPos p : changeable) {
                    world.func_175656_a(p, nextState);
                    world.func_175684_a(p, (Block)this, rand.nextInt(150) + time);
                }
                world.func_175656_a(pos, nextState);
                SoundUtil.playBlockPlace(world, pos);
            }
            world.func_175684_a(pos, (Block)this, rand.nextInt(150) + time);
        } else if (stage != next) {
            if (BlockWaterGel.notTouchingWater(world, pos)) {
                world.func_175656_a(pos, nextState);
                world.func_175684_a(pos, (Block)this, rand.nextInt(150) + 400);
            } else {
                world.func_175684_a(pos, (Block)this, rand.nextInt(150) + 600);
            }
        }
    }

    private static boolean notTouchingWater(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!BlockWaterGel.isWater(world, pos.func_177972_a(face))) continue;
            return false;
        }
        return true;
    }

    private static boolean isWater(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150355_j;
    }

    private boolean canSpread(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        GelStage stage = (GelStage)((Object)state.func_177229_b(PROP_STAGE));
        return stage.soundType;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        GelStage stage = (GelStage)((Object)state.func_177229_b(PROP_STAGE));
        return stage.hardness;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BCFactoryItems.gelledWater;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        GelStage stage = (GelStage)((Object)state.func_177229_b(PROP_STAGE));
        if (stage.spreading) {
            return random.nextInt(2) + 1;
        }
        return 1;
    }

    public static enum GelStage implements IStringSerializable
    {
        SPREAD_0(0.3f, true, 3.0f),
        SPREAD_1(0.4f, true, 3.0f),
        SPREAD_2(0.6f, true, 3.0f),
        SPREAD_3(0.8f, true, 3.0f),
        GELLING_0(1.0f, false, 0.6f),
        GELLING_1(1.2f, false, 0.6f),
        GEL(1.5f, false, 0.1f);

        public static final GelStage[] VALUES;
        public final SoundType soundType;
        public final String modelName = this.name().toLowerCase(Locale.ROOT);
        public final boolean spreading;
        public final float hardness;

        private GelStage(float pitch, boolean spreading, float hardness) {
            this.soundType = new SoundType(SoundType.field_185859_l.field_185860_m, pitch, SoundEvents.field_187872_fl, SoundEvents.field_187888_ft, SoundEvents.field_187884_fr, SoundEvents.field_187878_fo, SoundEvents.field_187876_fn);
            this.spreading = spreading;
            this.hardness = hardness;
        }

        public String func_176610_l() {
            return this.modelName;
        }

        public static GelStage fromMeta(int meta) {
            if (meta < 0) {
                return GEL;
            }
            return VALUES[meta % VALUES.length];
        }

        public int getMeta() {
            return this.ordinal();
        }

        public GelStage next() {
            if (this == SPREAD_0) {
                return SPREAD_1;
            }
            if (this == SPREAD_1) {
                return SPREAD_2;
            }
            if (this == SPREAD_2) {
                return SPREAD_3;
            }
            if (this == SPREAD_3) {
                return GELLING_0;
            }
            if (this == GELLING_0) {
                return GELLING_1;
            }
            return GEL;
        }

        static {
            VALUES = GelStage.values();
        }
    }
}

