/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.block;

import buildcraft.api.transport.pipe.ICustomPipeConnection;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.tile.TileHeatExchange;
import buildcraft.lib.block.BlockBCTile_Neptune;
import buildcraft.lib.block.IBlockWithFacing;
import buildcraft.lib.tile.TileBC_Neptune;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHeatExchange
extends BlockBCTile_Neptune
implements ICustomPipeConnection,
IBlockWithFacing {
    public static final IProperty<EnumExchangePart> PROP_PART = PropertyEnum.func_177709_a((String)"part", EnumExchangePart.class);
    public static final IProperty<Boolean> PROP_CONNECTED_Y = PropertyBool.func_177716_a((String)"connected_y");
    public static final IProperty<Boolean> PROP_CONNECTED_LEFT = PropertyBool.func_177716_a((String)"connected_left");
    public static final IProperty<Boolean> PROP_CONNECTED_RIGHT = PropertyBool.func_177716_a((String)"connected_right");

    public BlockHeatExchange(Material material, String id) {
        super(material, id);
    }

    @Override
    protected void addProperties(List<IProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(PROP_PART);
        properties.add(PROP_CONNECTED_Y);
        properties.add(PROP_CONNECTED_LEFT);
        properties.add(PROP_CONNECTED_RIGHT);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileHeatExchange) {
            TileHeatExchange exchange = (TileHeatExchange)tile;
            EnumExchangePart part = exchange.isStart() ? EnumExchangePart.START : (exchange.isEnd() ? EnumExchangePart.END : EnumExchangePart.MIDDLE);
            EnumFacing thisFacing = (EnumFacing)state.func_177229_b(PROP_FACING);
            state = state.func_177226_a(PROP_PART, (Comparable)((Object)part));
            state = state.func_177226_a(PROP_CONNECTED_Y, (Comparable)Boolean.valueOf(false));
            boolean connectLeft = BlockHeatExchange.doesNeighbourConnect(world, pos, thisFacing, thisFacing.func_176746_e());
            state = state.func_177226_a(PROP_CONNECTED_LEFT, (Comparable)Boolean.valueOf(connectLeft));
            boolean connectRight = BlockHeatExchange.doesNeighbourConnect(world, pos, thisFacing, thisFacing.func_176735_f());
            state = state.func_177226_a(PROP_CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connectRight));
        }
        state = state.func_177226_a(PROP_CONNECTED_Y, (Comparable)Boolean.valueOf(false));
        return state;
    }

    private static boolean doesNeighbourConnect(IBlockAccess world, BlockPos pos, EnumFacing thisFacing, EnumFacing dir) {
        IBlockState neighbour = world.func_180495_p(pos.func_177972_a(dir));
        if (neighbour.func_177230_c() == BCFactoryBlocks.heatExchange) {
            return neighbour.func_177229_b(PROP_FACING) == thisFacing;
        }
        return false;
    }

    @Override
    public TileBC_Neptune createTileEntity(World world, IBlockState state) {
        return new TileHeatExchange();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        return 0.0f;
    }

    public static enum EnumExchangePart implements IStringSerializable
    {
        START,
        MIDDLE,
        END;

        private final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);

        public String func_176610_l() {
            return this.lowerCaseName;
        }
    }
}

