/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.generation;

import buildcraft.api.core.BCLog;
import buildcraft.api.enums.EnumSpring;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.block.BlockSpring;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.energy.generation.OilGenerator;
import buildcraft.energy.tile.TileSpringOil;
import buildcraft.lib.BCLib;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class OilGenStructure {
    public final Box box;
    public final ReplaceType replaceType;

    public OilGenStructure(Box containingBox, ReplaceType replaceType) {
        this.box = containingBox;
        this.replaceType = replaceType;
    }

    public final void generate(World world, Box within) {
        Box intersect = this.box.getIntersect(within);
        if (intersect != null) {
            this.generateWithin(world, intersect);
        }
    }

    protected abstract void generateWithin(World var1, Box var2);

    protected abstract int countOilBlocks();

    public void setOilIfCanReplace(World world, BlockPos pos) {
        if (this.canReplaceForOil(world, pos)) {
            OilGenStructure.setOil(world, pos);
        }
    }

    public boolean canReplaceForOil(World world, BlockPos pos) {
        return this.replaceType.canReplace(world, pos);
    }

    public static void setOil(World world, BlockPos pos) {
        world.func_180501_a(pos, BCEnergyFluids.crudeOil[0].getBlock().func_176223_P(), 2);
    }

    public static class Spring
    extends OilGenStructure {
        public final BlockPos pos;

        public Spring(BlockPos pos) {
            super(new Box(pos, pos), ReplaceType.ALWAYS);
            this.pos = pos;
        }

        @Override
        protected void generateWithin(World world, Box intersect) {
        }

        @Override
        protected int countOilBlocks() {
            return 0;
        }

        public void generate(World world, int count) {
            TileSpringOil spring;
            IBlockState state = BCCoreBlocks.spring.func_176223_P();
            state = state.func_177226_a(BlockSpring.SPRING_TYPE, (Comparable)((Object)EnumSpring.OIL));
            world.func_175656_a(this.pos, state);
            TileEntity tile = world.func_175625_s(this.pos);
            if (tile instanceof TileSpringOil) {
                spring = (TileSpringOil)tile;
            } else {
                BCLog.logger.warn("[energy.gen.oil] Setting the blockstate didn't also set the tile at " + this.pos);
                spring = new TileSpringOil();
                spring.func_145834_a(world);
                spring.func_174878_a(this.pos);
                world.func_175690_a(this.pos, (TileEntity)spring);
            }
            spring.totalSources = count;
            if (BCLib.DEV) {
                BCLog.logger.info("[energy.gen.oil] Generated TileSpringOil as " + System.identityHashCode(tile));
            }
        }
    }

    public static class Spout
    extends OilGenStructure {
        public final BlockPos start;
        public final int radius;
        public final int height;
        private int count = 0;

        public Spout(BlockPos start, ReplaceType replaceType, int radius, int height) {
            super(Spout.createBox(start), replaceType);
            this.start = start;
            this.radius = radius;
            this.height = height;
        }

        private static Box createBox(BlockPos start) {
            return new Box(start, VecUtil.replaceValue((Vec3i)start, EnumFacing.Axis.Y, 256));
        }

        @Override
        protected void generateWithin(World world, Box intersect) {
            IBlockState state;
            this.count = 0;
            int segment = world.func_175726_f(this.start).func_76625_h();
            BlockPos worldTop = new BlockPos(this.start.func_177958_n(), segment + 16, this.start.func_177952_p());
            for (int y = segment; y >= this.start.func_177956_o() && ((state = world.func_180495_p(worldTop = worldTop.func_177977_b())).func_177230_c().isAir(state, (IBlockAccess)world, worldTop) || BlockUtil.getFluidWithFlowing(state.func_177230_c()) == null && !state.func_185904_a().func_76230_c()); --y) {
            }
            OilGenStructure tubeY = OilGenerator.createTubeY(this.start, worldTop.func_177956_o() - this.start.func_177956_o(), this.radius);
            tubeY.generate(world, tubeY.box);
            this.count += tubeY.countOilBlocks();
            BlockPos base = worldTop;
            for (int r = this.radius; r >= 0; --r) {
                OilGenStructure struct = OilGenerator.createTubeY(base, this.height, r);
                struct.generate(world, struct.box);
                base = base.func_177982_a(0, this.height, 0);
                this.count += struct.countOilBlocks();
            }
        }

        @Override
        protected int countOilBlocks() {
            if (this.count == 0) {
                throw new IllegalStateException("Called countOilBlocks before calling generateWithin!");
            }
            return this.count;
        }
    }

    public static class PatternTerrainHeight
    extends OilGenStructure {
        private final boolean[][] pattern;
        private final int depth;

        private PatternTerrainHeight(Box containingBox, ReplaceType replaceType, boolean[][] pattern, int depth) {
            super(containingBox, replaceType);
            this.pattern = pattern;
            this.depth = depth;
        }

        public static PatternTerrainHeight create(BlockPos start, ReplaceType replaceType, boolean[][] pattern, int depth) {
            BlockPos min = VecUtil.replaceValue((Vec3i)start, EnumFacing.Axis.Y, 1);
            BlockPos max = min.func_177982_a(pattern.length - 1, 255, pattern.length == 0 ? 0 : pattern[0].length - 1);
            Box box = new Box(min, max);
            return new PatternTerrainHeight(box, replaceType, pattern, depth);
        }

        @Override
        protected void generateWithin(World world, Box intersect) {
            for (int x = intersect.min().func_177958_n(); x <= intersect.max().func_177958_n(); ++x) {
                int px = x - this.box.min().func_177958_n();
                for (int z = intersect.min().func_177952_p(); z <= intersect.max().func_177952_p(); ++z) {
                    int y;
                    BlockPos upper;
                    int pz = z - this.box.min().func_177952_p();
                    if (!this.pattern[px][pz] || !this.canReplaceForOil(world, upper = world.func_175645_m(new BlockPos(x, 0, z)).func_177977_b())) continue;
                    for (y = 0; y < 5; ++y) {
                        world.func_175698_g(upper.func_177981_b(y));
                    }
                    for (y = 0; y < this.depth; ++y) {
                        this.setOilIfCanReplace(world, upper.func_177979_c(y));
                    }
                }
            }
        }

        @Override
        protected int countOilBlocks() {
            int count = 0;
            for (int x = 0; x < this.pattern.length; ++x) {
                for (int z = 0; z < this.pattern[x].length; ++z) {
                    if (!this.pattern[x][z]) continue;
                    ++count;
                }
            }
            return count * this.depth;
        }
    }

    public static class FlatPattern
    extends OilGenStructure {
        private final boolean[][] pattern;
        private final int depth;

        private FlatPattern(Box containingBox, ReplaceType replaceType, boolean[][] pattern, int depth) {
            super(containingBox, replaceType);
            this.pattern = pattern;
            this.depth = depth;
        }

        public static FlatPattern create(BlockPos start, ReplaceType replaceType, boolean[][] pattern, int depth) {
            BlockPos min = start.func_177982_a(0, 1 - depth, 0);
            BlockPos max = start.func_177982_a(pattern.length - 1, 0, pattern.length == 0 ? 0 : pattern[0].length - 1);
            Box box = new Box(min, max);
            return new FlatPattern(box, replaceType, pattern, depth);
        }

        @Override
        protected void generateWithin(World world, Box intersect) {
            BlockPos start = this.box.min();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)intersect.min(), (BlockPos)intersect.max())) {
                int z;
                int x = pos.func_177958_n() - start.func_177958_n();
                if (!this.pattern[x][z = pos.func_177952_p() - start.func_177952_p()]) continue;
                this.setOilIfCanReplace(world, pos);
            }
        }

        @Override
        protected int countOilBlocks() {
            int count = 0;
            for (int x = 0; x < this.pattern.length; ++x) {
                for (int z = 0; z < this.pattern[x].length; ++z) {
                    if (!this.pattern[x][z]) continue;
                    ++count;
                }
            }
            return count * this.depth;
        }
    }

    public static class GenByPredicate
    extends OilGenStructure {
        public final Predicate<BlockPos> predicate;

        public GenByPredicate(Box containingBox, ReplaceType replaceType, Predicate<BlockPos> predicate) {
            super(containingBox, replaceType);
            this.predicate = predicate;
        }

        @Override
        protected void generateWithin(World world, Box intersect) {
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)intersect.min(), (BlockPos)intersect.max())) {
                if (!this.predicate.test(pos)) continue;
                this.setOilIfCanReplace(world, pos);
            }
        }

        @Override
        protected int countOilBlocks() {
            int count = 0;
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.box.min(), (BlockPos)this.box.max())) {
                if (!this.predicate.test(pos)) continue;
                ++count;
            }
            return count;
        }
    }

    public static enum ReplaceType {
        ALWAYS{

            @Override
            public boolean canReplace(World world, BlockPos pos) {
                return true;
            }
        }
        ,
        IS_FOR_LAKE{

            @Override
            public boolean canReplace(World world, BlockPos pos) {
                return ALWAYS.canReplace(world, pos);
            }
        };


        public abstract boolean canReplace(World var1, BlockPos var2);
    }
}

