/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tiles.ITileAreaProvider;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.core.BCCoreConfig;
import buildcraft.core.marker.VolumeCache;
import buildcraft.core.marker.VolumeConnection;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.misc.PermissionUtil;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.data.Box;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.TileMarker;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMarkerVolume
extends TileMarker<VolumeConnection>
implements ITileAreaProvider {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("marker_volume");
    public static final int NET_SIGNALS_ON = IDS.allocId("SIGNALS_ON");
    public static final int NET_SIGNALS_OFF = IDS.allocId("SIGNALS_OFF");
    private boolean showSignals = false;

    public TileMarkerVolume() {
        this.caps.addCapabilityInstance(TilesAPI.CAP_TILE_AREA_PROVIDER, this, EnumPipePart.VALUES);
    }

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public boolean isShowingSignals() {
        return this.showSignals;
    }

    public VolumeCache getCache() {
        return VolumeCache.INSTANCE;
    }

    @Override
    public boolean isActiveForRender() {
        return this.showSignals || this.getCurrentConnection() != null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("showSignals", this.showSignals);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.showSignals = nbt.func_74767_n("showSignals");
    }

    public void switchSignals() {
        if (!this.field_145850_b.field_72995_K) {
            this.showSignals = !this.showSignals;
            this.func_70296_d();
            this.sendNetworkUpdate(this.showSignals ? NET_SIGNALS_ON : NET_SIGNALS_OFF);
        }
    }

    private void readNewSignalState(boolean shouldShow) {
        boolean before = this.isActiveForRender();
        this.showSignals = shouldShow;
        if (before != this.isActiveForRender()) {
            this.redrawBlock();
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            buffer.writeBoolean(this.showSignals);
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_SIGNALS_ON) {
                this.readNewSignalState(true);
            } else if (id == NET_SIGNALS_OFF) {
                this.readNewSignalState(false);
            } else if (id == NET_RENDER_DATA) {
                this.readNewSignalState(buffer.readBoolean());
            }
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return BCCoreConfig.markerMaxDistance * 4 * BCCoreConfig.markerMaxDistance;
    }

    public void onManualConnectionAttempt(EntityPlayer player) {
        if (PermissionUtil.hasPermission(PermissionUtil.PERM_EDIT, player, this.getPermBlock())) {
            MarkerSubCache cache = this.getLocalCache();
            for (BlockPos other : cache.getValidConnections(this.func_174877_v())) {
                TileMarkerVolume tile = (TileMarkerVolume)cache.getMarker(other);
                if (tile == null || !PermissionUtil.hasPermission(PermissionUtil.PERM_EDIT, player, this.getPermBlock())) continue;
                cache.tryConnect(this.func_174877_v(), other);
            }
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("Min = " + this.min());
        left.add("Max = " + this.max());
        left.add("Signals = " + this.showSignals);
    }

    @Override
    public BlockPos min() {
        VolumeConnection connection = (VolumeConnection)this.getCurrentConnection();
        return connection == null ? this.func_174877_v() : connection.getBox().min();
    }

    @Override
    public BlockPos max() {
        VolumeConnection connection = (VolumeConnection)this.getCurrentConnection();
        return connection == null ? this.func_174877_v() : connection.getBox().max();
    }

    @Override
    public void removeFromWorld() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        VolumeConnection connection = (VolumeConnection)this.getCurrentConnection();
        if (connection != null) {
            ImmutableList allPositions = ImmutableList.copyOf(connection.getMarkerPositions());
            for (BlockPos p : allPositions) {
                this.field_145850_b.func_175655_b(p, true);
            }
        }
    }

    @Override
    public boolean isValidFromLocation(BlockPos pos) {
        VolumeConnection connection = (VolumeConnection)this.getCurrentConnection();
        if (connection == null) {
            return false;
        }
        Box box = connection.getBox();
        if (box.contains(pos)) {
            return false;
        }
        for (BlockPos p : PositionUtil.getCorners(box.min(), box.max())) {
            if (!PositionUtil.isNextTo(p, pos)) continue;
            return true;
        }
        return false;
    }
}

