/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.IBuildCraftMod;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public enum BCModules implements IBuildCraftMod
{
    LIB,
    CORE,
    BUILDERS,
    ENERGY,
    FACTORY,
    ROBOTICS,
    SILICON,
    TRANSPORT,
    COMPAT;

    public static final BCModules[] VALUES;
    private static boolean hasChecked;
    public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);
    private final String modId = "buildcraft" + this.lowerCaseName;
    private boolean loaded;

    private static void checkLoadStatus() {
        if (hasChecked) {
            return;
        }
        hasChecked = true;
        if (!Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("You can only use EnumBuidCraftModule.isLoaded from pre-init onwards!");
        }
        for (BCModules module : VALUES) {
            module.loaded = Loader.isModLoaded((String)module.modId);
        }
    }

    public static boolean isBcMod(String testModId) {
        for (BCModules mod : VALUES) {
            if (!mod.modId.equals(testModId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    public boolean isLoaded() {
        BCModules.checkLoadStatus();
        return this.loaded;
    }

    public ResourceLocation createLocation(String path) {
        return new ResourceLocation(this.getModId(), path);
    }

    public ModelResourceLocation createModelLocation(String path, String variant) {
        return new ModelResourceLocation(this.getModId() + ":" + path + "#" + variant);
    }

    public ModelResourceLocation createModelLocation(String pathAndVariant) {
        return new ModelResourceLocation(this.getModId() + ":" + pathAndVariant);
    }

    static {
        VALUES = BCModules.values();
        hasChecked = false;
    }
}

