/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockSnapshot {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final et pos;
    private final int dimId;
    @Nullable
    private awt replacedBlock;
    private int flag;
    @Nullable
    private final fy nbt;
    @Nullable
    private WeakReference<amu> world;
    private final nf registryName;
    private final int meta;

    public BlockSnapshot(amu world, et pos, awt state) {
        this(world, pos, state, BlockSnapshot.getTileNBT(world.r(pos)));
    }

    public BlockSnapshot(amu world, et pos, awt state, @Nullable fy nbt) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos.h();
        this.setReplacedBlock(state);
        this.registryName = state.u().getRegistryName();
        this.meta = state.u().e(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.V().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(amu world, et pos, awt state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    @Deprecated
    public BlockSnapshot(int dimension, et pos, String modId, String blockName, int meta, int flag, @Nullable fy nbt) {
        this(dimension, pos, new nf(modId, blockName), meta, flag, nbt);
    }

    public BlockSnapshot(int dimension, et pos, nf registryName, int meta, int flag, @Nullable fy nbt) {
        this.dimId = dimension;
        this.pos = pos.h();
        this.setFlag(flag);
        this.registryName = registryName;
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(amu world, et pos) {
        return new BlockSnapshot(world, pos, world.o(pos));
    }

    public static BlockSnapshot getBlockSnapshot(amu world, et pos, int flag) {
        return new BlockSnapshot(world, pos, world.o(pos), flag);
    }

    public static BlockSnapshot readFromNBT(fy tag) {
        return new BlockSnapshot(tag.h("dimension"), new et(tag.h("posX"), tag.h("posY"), tag.h("posZ")), new nf(tag.l("blockMod"), tag.l("blockName")), tag.h("metadata"), tag.h("flag"), tag.q("hasTE") ? tag.p("tileEntity") : null);
    }

    @Nullable
    private static fy getTileNBT(@Nullable avj te) {
        if (te == null) {
            return null;
        }
        fy nbt = new fy();
        te.b(nbt);
        return nbt;
    }

    public awt getCurrentBlock() {
        return this.getWorld().o(this.getPos());
    }

    public amu getWorld() {
        amu world;
        amu amu2 = world = this.world != null ? (amu)this.world.get() : null;
        if (world == null) {
            world = FMLCommonHandler.instance().getMinecraftServerInstance().a(this.getDimId());
            this.world = new WeakReference<amu>(world);
        }
        return world;
    }

    public awt getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = ForgeRegistries.BLOCKS.getValue(this.getRegistryName()).a(this.getMeta());
        }
        return this.replacedBlock;
    }

    @Nullable
    public avj getTileEntity() {
        return this.getNbt() != null ? avj.a((amu)this.getWorld(), (fy)this.getNbt()) : null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean notifyNeighbors) {
        return this.restoreToLocation(this.getWorld(), this.getPos(), force, notifyNeighbors);
    }

    public boolean restoreToLocation(amu world, et pos, boolean force, boolean notifyNeighbors) {
        awt current = this.getCurrentBlock();
        awt replaced = this.getReplacedBlock();
        if (current.u() != replaced.u() || current.u().e(current) != replaced.u().e(replaced)) {
            if (force) {
                world.a(pos, replaced, notifyNeighbors ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, notifyNeighbors ? 3 : 2);
        world.a(pos, current, replaced, notifyNeighbors ? 3 : 2);
        avj te = null;
        if (this.getNbt() != null && (te = world.r(pos)) != null) {
            te.a(this.getNbt());
            te.y_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][notifyNeighbors: %s]", world.V().j(), pos.p(), pos.q(), pos.r(), replaced.u().e(replaced), replaced.u().delegate.name(), te, force, notifyNeighbors);
        }
        return true;
    }

    public void writeToNBT(fy compound) {
        compound.a("blockMod", this.getRegistryName().b());
        compound.a("blockName", this.getRegistryName().a());
        compound.a("posX", this.getPos().p());
        compound.a("posY", this.getPos().q());
        compound.a("posZ", this.getPos().r());
        compound.a("flag", this.getFlag());
        compound.a("dimension", this.getDimId());
        compound.a("metadata", this.getMeta());
        compound.a("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.a("tileEntity", (gn)this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!this.getPos().equals((Object)other.getPos())) {
            return false;
        }
        if (!this.getRegistryName().equals((Object)other.getRegistryName())) {
            return false;
        }
        return Objects.equals(this.getNbt(), other.getNbt());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + this.getPos().hashCode();
        hash = 73 * hash + this.getRegistryName().hashCode();
        hash = 73 * hash + Objects.hashCode(this.getNbt());
        return hash;
    }

    public et getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(awt replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    @Nullable
    public fy getNbt() {
        return this.nbt;
    }

    public void setWorld(amu world) {
        this.world = new WeakReference<amu>(world);
    }

    public nf getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

