/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionBase
extends Explosion {
    public ExplosionBase(World world, Entity entity, double x, double y, double z, float size, boolean flaming, boolean damagesTerrain) {
        super(world, entity, x, y, z, size, flaming, damagesTerrain);
    }

    public void func_77279_a(boolean spawnParticles) {
        this.playExplosionSound();
        this.spawnExplosionParticle();
        for (BlockPos blockpos : this.func_180343_e()) {
            IBlockState state = this.field_77287_j.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (spawnParticles) {
                this.spawnBlockExplosionParticles(blockpos);
            }
            if (state.func_185904_a() != Material.field_151579_a) {
                this.destroyBlock(block, state, blockpos);
                continue;
            }
            if (!this.doesCauseFire() || this.field_77287_j.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(blockpos.func_177977_b()).func_185913_b() || this.field_77290_i.nextInt(3) != 0) continue;
            this.field_77287_j.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void destroyBlock(Block block, IBlockState state, BlockPos pos) {
        if (this.doesDestroyBlocks()) {
            if (block.func_149659_a((Explosion)this)) {
                block.func_180653_a(this.field_77287_j, pos, this.field_77287_j.func_180495_p(pos), 1.0f / this.field_77280_f, 0);
            }
            block.onBlockExploded(this.field_77287_j, pos, (Explosion)this);
        }
    }

    public void playExplosionSound() {
        this.field_77287_j.func_184148_a((EntityPlayer)null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    public void spawnExplosionParticle() {
        EnumParticleTypes particle = this.field_77280_f >= 2.0f && this.field_82755_b ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_LARGE;
        this.field_77287_j.func_175688_a(particle, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
    }

    public void spawnBlockExplosionParticles(BlockPos pos) {
        double particleX = (float)pos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
        double particleY = (float)pos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
        double particleZ = (float)pos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
        double velocityX = -this.field_77284_b;
        double velocityY = -this.field_77285_c;
        double velocityZ = -this.field_77282_d;
        double d6 = MathHelper.func_76133_a((double)(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ));
        velocityX /= d6;
        velocityY /= d6;
        velocityZ /= d6;
        double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1) * (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f);
        this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (particleX + this.field_77284_b) / 2.0, (particleY + this.field_77285_c) / 2.0, (particleZ + this.field_77282_d) / 2.0, velocityX *= d7, velocityY *= d7, velocityZ *= d7, new int[0]);
        this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, particleX, particleY, particleZ, velocityX, velocityY, velocityZ, new int[0]);
    }

    public boolean doesCauseFire() {
        return this.field_77286_a;
    }

    public boolean doesDestroyBlocks() {
        return this.field_82755_b;
    }

    public Random getRandom() {
        return this.field_77290_i;
    }

    public World getWorld() {
        return this.field_77287_j;
    }

    public float getSize() {
        return this.field_77280_f;
    }

    public double getX() {
        return this.field_77284_b;
    }

    public double getY() {
        return this.field_77285_c;
    }

    public double getZ() {
        return this.field_77282_d;
    }
}

