/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.darkhax.bookshelf.block.IColorfulBlock;
import net.darkhax.bookshelf.block.ITileEntityBlock;
import net.darkhax.bookshelf.item.IColorfulItem;
import net.darkhax.bookshelf.item.ICustomMesh;
import net.darkhax.bookshelf.item.ICustomModel;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.LootBuilder;
import net.darkhax.bookshelf.registry.AutoRegistry;
import net.darkhax.bookshelf.registry.IAutoRegistry;
import net.darkhax.bookshelf.registry.IVariant;
import net.darkhax.bookshelf.util.GameUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RegistryHelper {
    private static final List<RegistryHelper> HELPERS = NonNullList.func_191196_a();
    private final String modid;
    private final NonNullList<Item> items = NonNullList.func_191196_a();
    private final NonNullList<Block> blocks = NonNullList.func_191196_a();
    private final NonNullList<SoundEvent> sounds = NonNullList.func_191196_a();
    private final NonNullList<EntityEntryBuilder<? extends Entity>> entities = NonNullList.func_191196_a();
    private final Multimap<ResourceLocation, LootBuilder> lootTableEntries = HashMultimap.create();
    private final List<ICustomMesh> customMeshes = NonNullList.func_191196_a();
    private final List<Item> coloredItems = NonNullList.func_191196_a();
    private final List<Block> coloredBlocks = NonNullList.func_191196_a();
    private final List<ITileEntityBlock> tileProviders = NonNullList.func_191196_a();
    private final List<IRecipe> recipes = NonNullList.func_191196_a();
    private CreativeTabs tab;
    private Object modInstance;
    private IAutoRegistry autoRegistry;

    public RegistryHelper() {
        this(Loader.instance().activeModContainer().getModId());
    }

    public RegistryHelper(@Nonnull String modid) {
        this.modid = modid;
        HELPERS.add(this);
    }

    public RegistryHelper enableAutoRegistration() {
        this.autoRegistry = this.getNewAutoRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this.autoRegistry);
        return this;
    }

    public boolean hasAutoRegistry() {
        return this.autoRegistry != null;
    }

    public IAutoRegistry getAutoRegistry() {
        return this.autoRegistry;
    }

    public void setModInstance(Object instance) {
        this.modInstance = instance;
    }

    public Object getModInstance() {
        if (this.modInstance == null) {
            Constants.LOG.error("Registry helper for " + this.modid + " requires a mod instance be set. Attempting to get instance with mod ID. Please ask the mod author to set this themselves.", new Object[0]);
            for (ModContainer container : Loader.instance().getActiveModList()) {
                if (!this.modid.equalsIgnoreCase(container.getModId())) continue;
                this.modInstance = container.getMod();
                break;
            }
        }
        return this.modInstance;
    }

    public CreativeTabs getTab() {
        return this.tab;
    }

    public RegistryHelper setTab(CreativeTabs tab) {
        this.tab = tab;
        return this;
    }

    public String getModid() {
        return this.modid;
    }

    public NonNullList<Item> getItems() {
        return this.items;
    }

    public NonNullList<Block> getBlocks() {
        return this.blocks;
    }

    public NonNullList<SoundEvent> getSounds() {
        return this.sounds;
    }

    public List<EntityEntryBuilder<? extends Entity>> getEntities() {
        return this.entities;
    }

    public Block registerBlock(@Nonnull Block block, @Nonnull String id) {
        return this.registerBlock(block, new ItemBlock(block), id);
    }

    public Block registerBlock(@Nonnull Block block, @Nonnull ItemBlock itemBlock, @Nonnull String id) {
        block.setRegistryName(this.modid, id);
        block.func_149663_c(this.modid + "." + id.toLowerCase().replace("_", "."));
        this.blocks.add((Object)block);
        this.registerItem((Item)itemBlock, id);
        if (this.tab != null) {
            block.func_149647_a(this.tab);
        }
        if (block instanceof IColorfulBlock) {
            this.coloredBlocks.add(block);
        }
        if (block instanceof ITileEntityBlock) {
            this.tileProviders.add((ITileEntityBlock)block);
        }
        return block;
    }

    public Item registerItem(@Nonnull Item item, @Nonnull String id) {
        return this.registerItem(item, new ResourceLocation(this.modid, id));
    }

    public Item registerItem(@Nonnull Block block, @Nonnull String id) {
        return this.registerItem((Item)new ItemBlock(block), id);
    }

    public Item registerItem(@Nonnull Item item, @Nonnull ResourceLocation id) {
        item.setRegistryName(id);
        item.func_77655_b(id.func_110624_b().replaceAll("_", ".") + "." + id.func_110623_a().toLowerCase().replace("_", "."));
        this.items.add((Object)item);
        if (this.tab != null) {
            item.func_77637_a(this.tab);
        }
        if (GameUtils.isClient()) {
            if (item instanceof ICustomMesh) {
                ICustomMesh mesh = (ICustomMesh)item;
                this.customMeshes.add(mesh);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh.getCustomMesh());
            }
            if (item instanceof IColorfulItem) {
                this.coloredItems.add(item);
            }
        }
        return item;
    }

    public SoundEvent registerSound(String name) {
        ResourceLocation id = new ResourceLocation(this.modid, name);
        SoundEvent sound = (SoundEvent)new SoundEvent(id).setRegistryName(id);
        this.sounds.add((Object)sound);
        return sound;
    }

    public IRecipe addShapedRecipe(String id, ItemStack output, Object ... inputs) {
        return this.registerRecipe(id, (IRecipe)new ShapedOreRecipe(null, output, inputs));
    }

    public IRecipe addShapelessRecipe(String id, ItemStack output, Object ... inputs) {
        return this.registerRecipe(id, (IRecipe)new ShapelessOreRecipe(null, output, inputs));
    }

    public IRecipe registerRecipe(String id, IRecipe recipe) {
        recipe.setRegistryName(new ResourceLocation(this.modid, id));
        this.recipes.add(recipe);
        return recipe;
    }

    public List<IRecipe> getRecipes() {
        return this.recipes;
    }

    public <T extends Entity> EntityEntryBuilder<T> registerEntity(Class<T> entClass, String id, int networkId) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.id(new ResourceLocation(this.modid, id), networkId);
        builder.name(this.modid + "." + id);
        builder.entity(entClass);
        this.entities.add((Object)builder);
        return builder;
    }

    public <T extends Entity> EntityEntryBuilder<T> registerMob(Class<T> entClass, String id, int networkId, int primary, int seconday) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.id(new ResourceLocation(this.modid, id), networkId);
        builder.name(this.modid + "." + id);
        builder.entity(entClass);
        builder.tracker(64, 1, true);
        builder.egg(primary, seconday);
        this.entities.add((Object)builder);
        return builder;
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, Item item, int meta, int amount) {
        return this.addLoot(location, name, pool, weight, item, meta, amount, amount);
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, Item item, int meta, int min, int max) {
        LootBuilder loot = this.addLoot(location, name, pool, weight, item, meta);
        loot.addFunction((LootFunction)new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max)));
        return loot;
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, Item item, int meta) {
        LootBuilder loot = this.addLoot(location, name, pool, weight, item);
        loot.addFunction((LootFunction)new SetMetadata(new LootCondition[0], new RandomValueRange((float)meta, (float)meta)));
        return loot;
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, Item item) {
        return this.addLoot(location, new LootBuilder(this.modid + ":" + name, pool, weight, item));
    }

    public LootBuilder addLoot(ResourceLocation location, String name, String pool, int weight, int quality, Item item, List<LootCondition> conditions, List<LootFunction> functions) {
        return this.addLoot(location, new LootBuilder(this.modid + ":" + name, pool, weight, quality, item, conditions, functions));
    }

    public LootBuilder addLoot(ResourceLocation location, LootBuilder builder) {
        this.lootTableEntries.put((Object)location, (Object)builder);
        return builder;
    }

    public Multimap<ResourceLocation, LootBuilder> getLootTableEntries() {
        return this.lootTableEntries;
    }

    public IAutoRegistry getNewAutoRegistry() {
        return new AutoRegistry(this);
    }

    public List<ITileEntityBlock> getTileProviders() {
        return this.tileProviders;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Block block) {
        this.registerInventoryModel(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Block block, @Nonnull String prefix, String ... variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            this.registerInventoryModel(Item.func_150898_a((Block)block), meta, block.getRegistryName().toString() + "_" + (prefix.isEmpty() ? prefix : prefix + "_") + variants[meta]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Block block, int meta, @Nonnull String modelName) {
        this.registerInventoryModel(Item.func_150898_a((Block)block), meta, modelName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Item item) {
        if (item instanceof IVariant) {
            IVariant variant = (IVariant)item;
            this.registerInventoryModel(item, variant.getPrefix(), variant.getVariant());
        } else if (item instanceof ICustomModel) {
            ((ICustomModel)item).registerMeshModels();
        } else {
            this.registerInventoryModel(item, 0, item.getRegistryName().toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Item item, @Nonnull String prefix, String ... variants) {
        for (int meta = 0; meta < variants.length; ++meta) {
            this.registerInventoryModel(item, meta, item.getRegistryName().toString() + "_" + (prefix.isEmpty() ? prefix : prefix + "_") + variants[meta]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerInventoryModel(@Nonnull Item item, int meta, @Nonnull String modelName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(modelName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public List<Item> getColoredItems() {
        return this.coloredItems;
    }

    @SideOnly(value=Side.CLIENT)
    public List<Block> getColoredBlocks() {
        return this.coloredBlocks;
    }

    public static List<RegistryHelper> getAllHelpers() {
        return HELPERS;
    }
}

