/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.stackable;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.IThing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

class OreThing
implements IThing.Zwieback {
    @Nonnull
    private final String name;
    @Nonnull
    private NonNullList<ItemStack> ores = new NNList<ItemStack>();

    OreThing(@Nonnull String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public IThing bake() {
        this.ores = OreDictionary.getOres((String)this.name);
        return this;
    }

    @Override
    @Nullable
    public IThing rebake() {
        return this.ores.isEmpty() ? null : this;
    }

    @Override
    public boolean is(@Nullable Item item) {
        for (ItemStack oreStack : this.ores) {
            if (oreStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is(@Nullable ItemStack itemStack) {
        for (ItemStack oreStack : this.ores) {
            if (itemStack == null || itemStack.func_190926_b() || itemStack.func_77973_b() != oreStack.func_77973_b() || oreStack.func_77981_g() && oreStack.func_77952_i() != Short.MAX_VALUE && oreStack.func_77960_j() != itemStack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is(@Nullable Block block) {
        for (ItemStack oreStack : this.ores) {
            if (block == null || Item.func_150898_a((Block)block) != oreStack.func_77973_b() && Block.func_149634_a((Item)oreStack.func_77973_b()) != block) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NNList<Item> getItems() {
        NNList<Item> result = new NNList<Item>();
        for (ItemStack oreStack : this.ores) {
            if (oreStack.func_190926_b() || result.contains(oreStack.func_77973_b())) continue;
            result.add(oreStack.func_77973_b());
        }
        return result;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getItemStacks() {
        return NNList.wrap(this.ores);
    }

    @Override
    @Nonnull
    public NNList<Block> getBlocks() {
        NNList<Block> result = new NNList<Block>();
        for (ItemStack oreStack : this.ores) {
            Block block;
            if (oreStack.func_190926_b() || (block = Block.func_149634_a((Item)oreStack.func_77973_b())) == Blocks.field_150350_a) continue;
            result.add(block);
        }
        return result;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("OreThing [name=%s, ores=%s]", this.name, this.ores);
    }
}

