/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.ISCPlugin;
import vswe.stevescarts.api.SCLoadingPlugin;
import vswe.stevescarts.compat.minecraft.CompatMinecraft;
import vswe.stevescarts.plugins.APIHelper;

public class PluginLoader {
    static List<ISCPlugin> pluginList;
    public static APIHelper apiHelper;

    public static void preInit(FMLPreInitializationEvent event) {
        StevesCarts.logger.info("Loading plugins");
        pluginList = new ArrayList<ISCPlugin>();
        ASMDataTable asmDataTable = event.getAsmData();
        Set asmDataSet = asmDataTable.getAll(SCLoadingPlugin.class.getCanonicalName());
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            String modId;
            StevesCarts.logger.info("Found plugin candidate:" + asmData.getClassName());
            if (asmData.getAnnotationInfo().size() != 0 && !Loader.isModLoaded((String)(modId = (String)asmData.getAnnotationInfo().get("dependentMod")))) {
                StevesCarts.logger.info("Plugin was NOT loaded due to mod '" + modId + "' missing, this isn't an error");
                continue;
            }
            try {
                Object object = Class.forName(asmData.getClassName()).newInstance();
                if (object instanceof ISCPlugin) {
                    pluginList.add((ISCPlugin)object);
                    StevesCarts.logger.info("Plugin " + asmData.getClassName() + " was found and has been initialized successfully!");
                    continue;
                }
                StevesCarts.logger.error("Plugin as it not an instanceof ISCPlugin, please contact the mod author of " + asmData.getClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                StevesCarts.logger.error("Plugin was not loaded due to an error, please contact the mod author of " + asmData.getClassName());
                e.printStackTrace();
            }
        }
        apiHelper = new APIHelper();
        StevesCarts.logger.info("Loaded " + pluginList.size() + " plugins");
    }

    public static void init(FMLInitializationEvent event) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"SC2 Plugins", (int)pluginList.size());
        for (ISCPlugin plugin : pluginList) {
            bar.step("Loading " + plugin.getClass().getCanonicalName());
            plugin.loadAddons(apiHelper);
        }
        new CompatMinecraft().loadAddons(apiHelper);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }
}

