/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotBuilder;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleRailer
extends ModuleWorker
implements ISuppliesModule {
    private boolean hasGeneratedAngles = false;
    private float[] railAngles;
    private DataParameter<Byte> RAILS;

    public ModuleRailer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotBuilder(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.RAILER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 100;
    }

    @Override
    public boolean work() {
        World world = this.getCart().field_70170_p;
        BlockPos next = this.getNextblock();
        int x = next.func_177958_n();
        int y = next.func_177956_o();
        int z = next.func_177952_p();
        ArrayList<Integer[]> pos = this.getValidRailPositions(x, y, z);
        if (this.doPreWork()) {
            boolean valid = false;
            for (int i = 0; i < pos.size(); ++i) {
                if (!this.tryPlaceTrack(pos.get(i)[0], pos.get(i)[1], pos.get(i)[2], false)) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.startWorking(12);
            } else {
                boolean front = false;
                for (int j = 0; j < pos.size(); ++j) {
                    if (!BlockRailBase.func_176562_d((World)world, (BlockPos)new BlockPos(pos.get(j)[0].intValue(), pos.get(j)[1].intValue(), pos.get(j)[2].intValue()))) continue;
                    front = true;
                    break;
                }
                if (!front) {
                    this.turnback();
                }
            }
            return true;
        }
        this.stopWorking();
        for (int k = 0; k < pos.size() && !this.tryPlaceTrack(pos.get(k)[0], pos.get(k)[1], pos.get(k)[2], true); ++k) {
        }
        return false;
    }

    protected ArrayList<Integer[]> getValidRailPositions(int x, int y, int z) {
        ArrayList<Integer[]> lst = new ArrayList<Integer[]>();
        if (y >= this.getCart().y()) {
            lst.add(new Integer[]{x, y + 1, z});
        }
        lst.add(new Integer[]{x, y, z});
        lst.add(new Integer[]{x, y - 1, z});
        return lst;
    }

    protected boolean validRail(Item item) {
        return Block.func_149634_a((Item)item) instanceof BlockRailBase;
    }

    private boolean tryPlaceTrack(int i, int j, int k, boolean flag) {
        if (this.isValidForTrack(new BlockPos(i, j, k), true)) {
            for (int l = 0; l < this.getInventorySize(); ++l) {
                if (this.getStack(l).func_190926_b() || !this.validRail(this.getStack(l).func_77973_b())) continue;
                if (flag) {
                    this.getCart().field_70170_p.func_175656_a(new BlockPos(i, j, k), Block.func_149634_a((Item)this.getStack(l).func_77973_b()).func_176203_a(this.getStack(l).func_77952_i()));
                    if (!this.getCart().hasCreativeSupplies()) {
                        ItemStack stack = this.getStack(l);
                        stack.func_190918_g(1);
                        if (this.getStack(l).func_190916_E() == 0) {
                            this.setStack(l, ItemStack.field_190927_a);
                        }
                        this.getCart().func_70296_d();
                    }
                }
                return true;
            }
            this.turnback();
            return true;
        }
        return false;
    }

    @Override
    public void initDw() {
        this.RAILS = this.createDw(DataSerializers.field_187191_a);
        this.registerDw(this.RAILS, (byte)0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateRails();
    }

    private void calculateRails() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        byte valid = 0;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).func_190926_b() || !this.validRail(this.getStack(i).func_77973_b())) continue;
            valid = (byte)(valid + 1);
        }
        this.updateDw(this.RAILS, valid);
    }

    public int getRails() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getRailCount();
        }
        return this.getDw(this.RAILS).byteValue();
    }

    public float getRailAngle(int i) {
        if (!this.hasGeneratedAngles) {
            this.railAngles = new float[this.getInventorySize()];
            for (int j = 0; j < this.getInventorySize(); ++j) {
                this.railAngles[j] = this.getCart().field_70146_Z.nextFloat() / 2.0f - 0.25f;
            }
            this.hasGeneratedAngles = true;
        }
        return this.railAngles[i];
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.calculateRails();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.func_190926_b() || !this.validRail(item.func_77973_b())) continue;
            return true;
        }
        return false;
    }
}

