/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFertilizer;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.workers.ModuleWorker;
import vswe.stevescarts.modules.workers.tools.ModuleFarmer;

public class ModuleFertilizer
extends ModuleWorker
implements ISuppliesModule {
    private int tankPosX;
    private int tankPosY = 20;
    private int range = 1;
    private int fert = 0;
    private final int fertPerBonemeal = 4;
    private final int maxStacksOfBones = 1;
    private final Random random = new Random();

    public ModuleFertilizer(EntityMinecartModular cart) {
        super(cart);
        this.tankPosX = this.guiWidth() - 21;
    }

    @Override
    public byte getWorkPriority() {
        return 127;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleFarmer)) continue;
            this.range = ((ModuleFarmer)module).getExternalRange();
            break;
        }
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/fertilize.png");
        this.drawImage(gui, this.tankPosX, this.tankPosY, 0, 0, 18, 27);
        float percentage = this.fert / this.getMaxFert();
        int size = (int)(percentage * 23.0f);
        this.drawImage(gui, this.tankPosX + 2, this.tankPosY + 2 + (23 - size), 18, 23 - size, 14, size);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, Localization.MODULES.ATTACHMENTS.FERTILIZERS.translate(new String[0]) + ": " + this.fert + " / " + this.getMaxFert(), x, y, this.tankPosX, this.tankPosY, 18, 27);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + 25;
    }

    @Override
    public int guiHeight() {
        return Math.max(super.guiHeight(), 50);
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFertilizer(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean work() {
        World world = this.getCart().field_70170_p;
        BlockPos next = this.getNextblock();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; !(j > this.range || this.random.nextInt(25) == 0 && this.fertilize(world, next.func_177982_a(i, 0, j))); ++j) {
            }
        }
        return false;
    }

    private boolean fertilize(World world, BlockPos pos) {
        IGrowable growable;
        IBlockState stateOfTopBlock = world.func_180495_p(pos);
        Block blockTop = stateOfTopBlock.func_177230_c();
        if (this.fert > 0 && blockTop instanceof IGrowable && (growable = (IGrowable)blockTop).func_176473_a(world, pos, stateOfTopBlock, false) && growable.func_180670_a(world, this.getCart().field_70146_Z, pos, stateOfTopBlock)) {
            growable.func_176474_b(world, this.getCart().field_70146_Z, pos, stateOfTopBlock);
            this.fert -= 2;
            return true;
        }
        return false;
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.fert);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.fert = data;
        }
    }

    @Override
    public void update() {
        super.update();
        this.loadSupplies();
    }

    private void loadSupplies() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        if (!this.getStack(0).func_190926_b()) {
            boolean isBoneMeal;
            boolean isBone = this.getStack(0).func_77973_b() == Items.field_151103_aS;
            boolean bl = isBoneMeal = this.getStack(0).func_77973_b() == Items.field_151100_aR && this.getStack(0).func_77952_i() == 15;
            if (isBone || isBoneMeal) {
                int amount = isBoneMeal ? 1 : 3;
                if (this.fert <= 4 * (192 - amount) && this.getStack(0).func_190916_E() > 0) {
                    ItemStack stack = this.getStack(0);
                    stack.func_190918_g(1);
                    this.fert += amount * 4;
                }
                if (this.getStack(0).func_190916_E() == 0) {
                    this.setStack(0, ItemStack.field_190927_a);
                }
            }
        }
    }

    private int getMaxFert() {
        return 768;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74777_a(this.generateNBTName("Fert", id), (short)this.fert);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.fert = tagCompound.func_74765_d(this.generateNBTName("Fert", id));
    }

    @Override
    public boolean haveSupplies() {
        return this.fert > 0;
    }
}

