/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.compat.forestry;

import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import vswe.stevescarts.api.farms.EnumHarvestResult;
import vswe.stevescarts.api.farms.ITreeModule;
import vswe.stevescarts.entitys.EntityMinecartModular;

public class ForestryTreeModule
implements ITreeModule {
    public ITreeRoot treeRoot = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    public Item sapling = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("forestry", "sapling"));
    public Block leaves = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("forestry", "leaves"));

    @Override
    public EnumHarvestResult isLeaves(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        return blockState.func_177230_c() == this.leaves ? EnumHarvestResult.ALLOW : EnumHarvestResult.SKIP;
    }

    @Override
    public EnumHarvestResult isWood(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        return blockState.func_177230_c().getRegistryName().func_110624_b().equals("forestry") && blockState.func_177230_c().getRegistryName().func_110623_a().startsWith("logs") ? EnumHarvestResult.ALLOW : EnumHarvestResult.SKIP;
    }

    @Override
    public boolean isSapling(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() == this.sapling;
    }

    @Override
    public boolean plantSapling(World world, BlockPos pos, @Nonnull ItemStack stack, FakePlayer fakePlayer) {
        ITree tree;
        if (stack.func_77973_b() == this.sapling && world.func_175623_d(pos.func_177984_a()) && (tree = this.treeRoot.getMember(stack)) != null && tree.canStay((IBlockAccess)world, pos.func_177984_a())) {
            this.treeRoot.plantSapling(world, tree, fakePlayer.func_146103_bH(), pos.func_177984_a());
            return true;
        }
        return false;
    }
}

