/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiUpgrade;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.InterfaceEffect;
import vswe.stevescarts.upgrades.InventoryEffect;

public class TileEntityUpgrade
extends TileEntityBase
implements IInventory,
ISidedInventory,
ITankHolder,
ITickable {
    public SCTank tank = new SCTank(this, 0, 0);
    private TileEntityCartAssembler master;
    private int type;
    private boolean initialized;
    private NBTTagCompound comp;
    private NonNullList<ItemStack> inventoryStacks;
    private int[] slotsForSide;
    private BlockUpgrade blockUpgrade = (BlockUpgrade)ModBlocks.UPGRADE.getBlock();
    private boolean isCreativeBroken;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiUpgrade(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerUpgrade((IInventory)inv, this);
    }

    public void setMaster(TileEntityCartAssembler master, EnumFacing side) {
        this.master = master;
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockUpgrade) {
            if (side != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockUpgrade.FACING, (Comparable)side).func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(this.getType())).func_177226_a((IProperty)BlockUpgrade.CONNECTED, (Comparable)Boolean.valueOf(master != null)));
            } else {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(this.getType())).func_177226_a((IProperty)BlockUpgrade.CONNECTED, (Comparable)Boolean.valueOf(master != null)));
            }
            this.func_70296_d();
        }
    }

    public EnumFacing getSide() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockUpgrade.FACING);
    }

    public TileEntityCartAssembler getMaster() {
        return this.master;
    }

    public void setType(int type) {
        this.setType(type, true);
    }

    public void setType(int type, boolean setBlockState) {
        this.type = type;
        if (setBlockState) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.blockUpgrade.func_176223_P().func_177226_a((IProperty)BlockUpgrade.FACING, (Comparable)this.getSide()).func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(type)).func_177226_a((IProperty)BlockUpgrade.CONNECTED, (Comparable)Boolean.valueOf(this.getMaster() != null)));
        }
        if (!this.initialized) {
            this.initialized = true;
            AssemblerUpgrade upgrade = this.getUpgrade();
            if (upgrade != null) {
                this.comp = new NBTTagCompound();
                this.slotsForSide = new int[upgrade.getInventorySize()];
                upgrade.init(this);
                if (upgrade.getInventorySize() > 0) {
                    this.inventoryStacks = NonNullList.func_191197_a((int)upgrade.getInventorySize(), (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < this.slotsForSide.length; ++i) {
                        this.slotsForSide[i] = i;
                    }
                }
            } else {
                this.inventoryStacks = null;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public NBTTagCompound getCompound() {
        return this.comp;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public AssemblerUpgrade getUpgrade() {
        return AssemblerUpgrade.getUpgrade(this.type);
    }

    public boolean hasInventory() {
        return this.inventoryStacks != null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setType(tagCompound.func_74771_c("Type"), false);
        ItemStackHelper.func_191283_b((NBTTagCompound)tagCompound, this.inventoryStacks);
        this.func_70296_d();
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.load(this, tagCompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.inventoryStacks != null) {
            ItemStackHelper.func_191282_a((NBTTagCompound)tagCompound, this.inventoryStacks);
        }
        tagCompound.func_74774_a("Type", (byte)this.type);
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.save(this, tagCompound);
        }
        return tagCompound;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void updateEntity() {
        if (this.getUpgrade() != null && this.getMaster() != null) {
            this.getUpgrade().update(this);
        }
    }

    @Override
    public void initGuiData(Container con, IContainerListener crafting) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.checkGuiData(this, (ContainerUpgrade)con, crafting, true);
        }
    }

    @Override
    public void checkGuiData(Container con, IContainerListener crafting) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.checkGuiData(this, (ContainerUpgrade)con, crafting, false);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.receiveGuiData(this, id, data);
        }
    }

    public int func_70302_i_() {
        if (this.inventoryStacks != null) {
            return this.inventoryStacks.size();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.func_70302_i_();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventoryStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return ItemStack.field_190927_a;
            }
            return this.master.func_70301_a(i);
        }
        if (i < 0 || i >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inventoryStacks.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return ItemStack.field_190927_a;
            }
            return this.master.func_70298_a(i, j);
        }
        if (i < 0 || i >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        if (((ItemStack)this.inventoryStacks.get(i)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() <= j) {
            ItemStack itemstack = (ItemStack)this.inventoryStacks.get(i);
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            return itemstack;
        }
        ItemStack itemstack2 = ((ItemStack)this.inventoryStacks.get(i)).func_77979_a(j);
        if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() == 0) {
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        return itemstack2;
    }

    @Nullable
    @Nonnull
    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        if (this.inventoryStacks == null) {
            if (this.master != null) {
                this.master.func_70299_a(i, itemstack);
            }
        } else {
            if (i < 0 || i >= this.func_70302_i_()) {
                return;
            }
            this.inventoryStacks.set(i, (Object)itemstack);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
                itemstack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        }
    }

    public String getInventoryName() {
        return "container.assemblerupgrade";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void closeInventory() {
    }

    public void openInventory() {
    }

    @Nonnull
    public ItemStack getStackInSlotOnClosing(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return ItemStack.field_190927_a;
            }
            return this.master.func_70301_a(i);
        }
        ItemStack item = this.func_70301_a(i);
        if (!item.func_190926_b()) {
            this.func_70299_a(i, ItemStack.field_190927_a);
            return item;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70296_d() {
        InventoryEffect inv;
        super.func_70296_d();
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            inv.onInventoryChanged(this);
        }
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack item) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return inv.isItemValid(slot, item);
        }
        return this.getMaster() != null && this.getMaster().func_94041_b(slot, item);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack item, EnumFacing side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return this.func_94041_b(slot, item);
        }
        return this.getMaster() != null && this.getMaster().func_180462_a(slot, item, side);
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack item, EnumFacing side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return true;
        }
        return this.getMaster() != null && this.getMaster().func_180461_b(slot, item, side);
    }

    @Override
    @Nonnull
    public ItemStack getInputContainer(int tankid) {
        return this.func_70301_a(0);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.func_70299_a(0, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @Nonnull ItemStack item) {
        TransferHandler.TransferItem(item, this, 1, 1, new ContainerUpgrade(null, this), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawImage(int tankid, GuiBase gui, TextureAtlasSprite sprite, int targetX, int targetY, int srcX, int srcY, int width, int height) {
        gui.drawIcon(sprite, gui.getGuiLeft() + targetX, gui.getGuiTop() + targetY, (float)width / 16.0f, (float)height / 16.0f, (float)srcX / 16.0f, (float)srcY / 16.0f);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int[] func_180463_a(EnumFacing side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return this.slotsForSide;
        }
        if (this.getMaster() != null) {
            return this.getMaster().func_180463_a(side);
        }
        return new int[0];
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setCreativeBroken() {
        this.isCreativeBroken = true;
    }

    public boolean isCreativeBroken() {
        return this.isCreativeBroken;
    }
}

