/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.util.FluidUtils;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerLiquid;
import vswe.stevescarts.containers.ContainerManager;
import vswe.stevescarts.containers.slots.SlotLiquidFilter;
import vswe.stevescarts.containers.slots.SlotLiquidManagerInput;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiLiquid;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.packet.PacketFluidSync;

public class TileEntityLiquid
extends TileEntityManager
implements ITankHolder {
    public SCTank[] tanks = new SCTank[4];
    private int tick;
    private static final int[] topSlots = new int[]{0, 3, 6, 9};
    private static final int[] botSlots = new int[]{1, 4, 7, 10};
    private static final int[] sideSlots = new int[0];

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiLiquid(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerLiquid((IInventory)inv, this);
    }

    public TileEntityLiquid() {
        for (int i = 0; i < 4; ++i) {
            this.tanks[i] = new SCTank(this, 32000, i);
        }
    }

    public SCTank[] getTanks() {
        return this.tanks;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.tick-- <= 0) {
            this.tick = 5;
            if (!this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 4; ++i) {
                    this.tanks[i].containerTransfer();
                }
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return 12;
    }

    @Override
    public String func_70005_c_() {
        return "container.fluidmanager";
    }

    @Override
    @Nonnull
    public ItemStack getInputContainer(int tankid) {
        return this.func_70301_a(tankid * 3);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.func_70299_a(tankid * 3, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @Nonnull ItemStack item) {
        TransferHandler.TransferItem(item, this, tankid * 3 + 1, tankid * 3 + 1, new ContainerLiquid(null, this), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
        this.func_70296_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawImage(int tankid, GuiBase gui, TextureAtlasSprite sprite, int targetX, int targetY, int srcX, int srcY, int width, int height) {
        gui.drawIcon(sprite, gui.getGuiLeft() + targetX, gui.getGuiTop() + targetY, (float)width / 16.0f, (float)height / 16.0f, (float)srcX / 16.0f, (float)srcY / 16.0f);
    }

    @Override
    protected boolean isTargetValid(TransferManager transfer) {
        return true;
    }

    @Override
    protected boolean doTransfer(TransferManager transfer) {
        int maximumToTransfer = this.hasMaxAmount(transfer.getSetting()) ? Math.min(this.getMaxAmount(transfer.getSetting()) - transfer.getWorkload(), 1000) : 1000;
        boolean sucess = false;
        if (this.toCart[transfer.getSetting()]) {
            boolean allFull = true;
            for (int i = 0; i < this.tanks.length; ++i) {
                int n = this.fillTank(transfer.getCart(), i, transfer.getSetting(), maximumToTransfer, false);
                if (n <= 0) continue;
                this.fillTank(transfer.getCart(), i, transfer.getSetting(), n, true);
                sucess = true;
                if (n >= maximumToTransfer) {
                    allFull = false;
                }
                if (!this.hasMaxAmount(transfer.getSetting())) break;
                transfer.setWorkload(transfer.getWorkload() + n);
                break;
            }
            if (allFull) {
                return false;
            }
        } else {
            ArrayList<ModuleTank> cartTanks = transfer.getCart().getTanks();
            for (IFluidTank iFluidTank : cartTanks) {
                int drain = this.drainTank(iFluidTank, transfer.getSetting(), maximumToTransfer, false);
                if (drain <= 0) continue;
                this.drainTank(iFluidTank, transfer.getSetting(), drain, true);
                sucess = true;
                if (!this.hasMaxAmount(transfer.getSetting())) break;
                transfer.setWorkload(transfer.getWorkload() + drain);
                break;
            }
        }
        if (sucess && this.hasMaxAmount(transfer.getSetting()) && transfer.getWorkload() == this.getMaxAmount(transfer.getSetting())) {
            transfer.setLowestSetting(transfer.getSetting() + 1);
        }
        return sucess;
    }

    private int fillTank(EntityMinecartModular cart, int tankId, int sideId, int fillAmount, boolean doFill) {
        if (this.isTankValid(tankId, sideId)) {
            FluidStack fluidToFill = this.tanks[tankId].drain(fillAmount, doFill);
            if (fluidToFill == null) {
                return 0;
            }
            fillAmount = fluidToFill.amount;
            if (this.isFluidValid(sideId, fluidToFill)) {
                ArrayList<ModuleTank> cartTanks = cart.getTanks();
                for (IFluidTank iFluidTank : cartTanks) {
                    fluidToFill.amount -= iFluidTank.fill(fluidToFill, doFill);
                    if (fluidToFill.amount > 0) continue;
                    return fillAmount;
                }
                return fillAmount - fluidToFill.amount;
            }
        }
        return 0;
    }

    private int drainTank(IFluidTank cartTank, int sideId, int drainAmount, boolean doDrain) {
        FluidStack drainedFluid = cartTank.drain(drainAmount, doDrain);
        if (drainedFluid == null) {
            return 0;
        }
        drainAmount = drainedFluid.amount;
        if (this.isFluidValid(sideId, drainedFluid)) {
            for (int i = 0; i < this.tanks.length; ++i) {
                SCTank tank = this.tanks[i];
                if (!this.isTankValid(i, sideId)) continue;
                FluidStack fluidStack = drainedFluid;
                fluidStack.amount -= tank.fill(drainedFluid, doDrain);
                if (drainedFluid.amount > 0) continue;
                return drainAmount;
            }
            return drainAmount - drainedFluid.amount;
        }
        return 0;
    }

    private boolean isTankValid(int tankId, int sideId) {
        return !(this.layoutType == 1 && tankId != sideId || this.layoutType == 2 && this.color[sideId] != this.color[tankId]);
    }

    private boolean isTankValid(int tankId, EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        switch (this.layoutType) {
            case 0: {
                return true;
            }
            case 1: {
                return tankId == this.facingToTankId(facing);
            }
            case 2: {
                return this.color[tankId] == this.facingToColorId(facing);
            }
        }
        return false;
    }

    private boolean isFluidValid(int sideId, FluidStack fluid) {
        ItemStack filter = this.func_70301_a(sideId * 3 + 2);
        FluidStack filterFluid = FluidUtils.getFluidStackInContainer((ItemStack)filter);
        return filterFluid == null || filterFluid.isFluidEqual(fluid);
    }

    public int getMaxAmount(int id) {
        return (int)(this.getMaxAmountBuckets(id) * 1000.0f);
    }

    public float getMaxAmountBuckets(int id) {
        switch (this.getAmountId(id)) {
            case 1: {
                return 0.25f;
            }
            case 2: {
                return 0.5f;
            }
            case 3: {
                return 0.75f;
            }
            case 4: {
                return 1.0f;
            }
            case 5: {
                return 2.0f;
            }
            case 6: {
                return 3.0f;
            }
            case 7: {
                return 5.0f;
            }
            case 8: {
                return 7.5f;
            }
            case 9: {
                return 10.0f;
            }
            case 10: {
                return 15.0f;
            }
        }
        return 0.0f;
    }

    public boolean hasMaxAmount(int id) {
        return this.getAmountId(id) != 0;
    }

    @Override
    public int getAmountCount() {
        return 11;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("Fluid" + i)));
        }
        this.setWorkload(nbttagcompound.func_74765_d("workload"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        for (int i = 0; i < 4; ++i) {
            if (this.tanks[i].getFluid() == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            this.tanks[i].getFluid().writeToNBT(compound);
            nbttagcompound.func_74782_a("Fluid" + i, (NBTBase)compound);
        }
        nbttagcompound.func_74777_a("workload", (short)this.getWorkload());
        return nbttagcompound;
    }

    @Override
    public void checkGuiData(ContainerManager conManager, IContainerListener crafting, boolean isNew) {
        super.checkGuiData(conManager, crafting, isNew);
        ContainerLiquid con = (ContainerLiquid)conManager;
        for (int i = 0; i < 4; ++i) {
            boolean changed = false;
            int id = 4 + i * 4;
            int amount1 = 4 + i * 4 + 1;
            int amount2 = 4 + i * 4 + 2;
            int meta = 4 + i * 4 + 3;
            if ((isNew || con.oldLiquids[i] != null) && this.tanks[i].getFluid() == null) {
                this.updateGuiData(con, crafting, id, (short)-1);
                changed = true;
            } else if (this.tanks[i].getFluid() != null) {
                if (isNew || con.oldLiquids[i] == null) {
                    this.updateGuiData(con, crafting, id, (short)this.tanks[i].getFluid().amount);
                    this.updateGuiData(con, crafting, amount1, this.getShortFromInt(true, this.tanks[i].getFluid().amount));
                    this.updateGuiData(con, crafting, amount2, this.getShortFromInt(false, this.tanks[i].getFluid().amount));
                    changed = true;
                } else {
                    NetworkManager.sendToWorld((INetworkPacket)new PacketFluidSync(this.tanks[i].getFluid(), this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension(), i), (World)this.func_145831_w());
                    if (con.oldLiquids[i].amount != this.tanks[i].getFluid().amount) {
                        this.updateGuiData(con, crafting, amount1, this.getShortFromInt(true, this.tanks[i].getFluid().amount));
                        this.updateGuiData(con, crafting, amount2, this.getShortFromInt(false, this.tanks[i].getFluid().amount));
                        changed = true;
                    }
                }
            }
            if (!changed) continue;
            con.oldLiquids[i] = this.tanks[i].getFluid() == null ? null : this.tanks[i].getFluid().copy();
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id > 3) {
            int tankid = (id -= 4) / 4;
            int contentid = id % 4;
            if (contentid == 0) {
                if (data == -1) {
                    this.tanks[tankid].setFluid(null);
                }
            } else if (this.tanks[tankid].getFluid() != null) {
                this.tanks[tankid].getFluid().amount = this.getIntFromShort(contentid == 1, this.tanks[tankid].getFluid().amount, data);
            }
        } else {
            super.receiveGuiData(id, data);
        }
    }

    private boolean isInput(int id) {
        return id % 3 == 0;
    }

    private boolean isOutput(int id) {
        return id % 3 == 1;
    }

    @Override
    public boolean func_94041_b(int slotId, @Nonnull ItemStack item) {
        if (this.isInput(slotId)) {
            return SlotLiquidManagerInput.isItemStackValid(item, this, -1);
        }
        if (this.isOutput(slotId)) {
            return SlotLiquidOutput.isItemStackValid(item);
        }
        return SlotLiquidFilter.isItemStackValid(item);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (side == 1) {
            return topSlots;
        }
        if (side == 0) {
            return botSlots;
        }
        return sideSlots;
    }

    public boolean canInsertItem(int slot, @Nonnull ItemStack item, int side) {
        return side == 1 && this.isInput(slot) && this.func_94041_b(slot, item);
    }

    public boolean canExtractItem(int slot, @Nonnull ItemStack item, int side) {
        return side == 0 && this.isOutput(slot);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getValidTank(facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.getValidTank(facing));
        }
        return super.getCapability(capability, facing);
    }

    public SCTank getValidTank(EnumFacing facing) {
        for (int i = 0; i < this.getTanks().length; ++i) {
            if (!this.isTankValid(i, facing)) continue;
            return this.getTanks()[i];
        }
        return null;
    }

    private int facingToColorId(EnumFacing facing) {
        switch (facing.func_176745_a()) {
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 1;
            }
        }
        return 1;
    }

    private int facingToTankId(EnumFacing facing) {
        switch (facing.func_176745_a()) {
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }
}

