/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerDistributor;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiDistributor;
import vswe.stevescarts.helpers.DistributorSetting;
import vswe.stevescarts.helpers.DistributorSide;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.packet.PacketStevesCarts;

public class TileEntityDistributor
extends TileEntityBase
implements IInventory,
ISidedInventory {
    private ArrayList<DistributorSide> sides = new ArrayList<DistributorSide>();
    private boolean dirty = true;
    private TileEntityManager[] inventories;
    public boolean hasTop;
    public boolean hasBot;
    private Map<EnumFacing, IFluidHandler> fluidHandlerMap;

    public TileEntityDistributor() {
        this.sides.add(new DistributorSide(0, Localization.GUI.DISTRIBUTOR.SIDE_ORANGE, EnumFacing.UP));
        this.sides.add(new DistributorSide(1, Localization.GUI.DISTRIBUTOR.SIDE_PURPLE, EnumFacing.DOWN));
        this.sides.add(new DistributorSide(2, Localization.GUI.DISTRIBUTOR.SIDE_YELLOW, EnumFacing.NORTH));
        this.sides.add(new DistributorSide(3, Localization.GUI.DISTRIBUTOR.SIDE_GREEN, EnumFacing.WEST));
        this.sides.add(new DistributorSide(4, Localization.GUI.DISTRIBUTOR.SIDE_BLUE, EnumFacing.SOUTH));
        this.sides.add(new DistributorSide(5, Localization.GUI.DISTRIBUTOR.SIDE_RED, EnumFacing.EAST));
        this.fluidHandlerMap = new HashMap<EnumFacing, IFluidHandler>();
        for (final EnumFacing facing : EnumFacing.values()) {
            this.fluidHandlerMap.put(facing, new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    IFluidTankProperties[] infos = new IFluidTankProperties[tanks.length];
                    for (int i = 0; i < infos.length; ++i) {
                        infos[i] = new FluidTankProperties(tanks[i].getFluid(), tanks[i].getCapacity());
                    }
                    return infos;
                }

                public int fill(FluidStack resource, boolean doFill) {
                    SCTank[] tanks = TileEntityDistributor.this.getTanks(facing);
                    int amount = 0;
                    for (SCTank tank : tanks) {
                        amount += tank.fill(resource, doFill);
                    }
                    return amount;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return TileEntityDistributor.this.drain(facing, resource, resource == null ? 0 : resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return TileEntityDistributor.this.drain(facing, null, maxDrain, doDrain);
                }
            });
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiDistributor(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerDistributor((IInventory)inv, this);
    }

    public ArrayList<DistributorSide> getSides() {
        return this.sides;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (DistributorSide side : this.getSides()) {
            side.setData(nbttagcompound.func_74762_e("Side" + side.getId()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        for (DistributorSide side : this.getSides()) {
            nbttagcompound.func_74768_a("Side" + side.getId(), side.getData());
        }
        return nbttagcompound;
    }

    @Override
    public void updateEntity() {
        this.dirty = true;
    }

    protected void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    protected void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketStevesCarts.sendPacket(id, data);
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0 || id == 1) {
            byte settingId = data[0];
            byte sideId = data[1];
            if (settingId >= 0 && settingId < DistributorSetting.settings.size() && sideId >= 0 && sideId < this.getSides().size()) {
                if (id == 0) {
                    this.getSides().get(sideId).set(settingId);
                } else {
                    this.getSides().get(sideId).reset(settingId);
                }
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public void initGuiData(Container con, IContainerListener crafting) {
    }

    @Override
    public void checkGuiData(Container con, IContainerListener crafting) {
        ContainerDistributor condist = (ContainerDistributor)con;
        for (int i = 0; i < this.getSides().size(); ++i) {
            DistributorSide side = this.getSides().get(i);
            if (side.getLowShortData() != condist.cachedValues.get(i * 2).shortValue()) {
                this.updateGuiData(con, crafting, i * 2, side.getLowShortData());
                condist.cachedValues.set(i * 2, side.getLowShortData());
            }
            if (side.getHighShortData() == condist.cachedValues.get(i * 2 + 1).shortValue()) continue;
            this.updateGuiData(con, crafting, i * 2 + 1, side.getHighShortData());
            condist.cachedValues.set(i * 2 + 1, side.getHighShortData());
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        int sideId = id / 2;
        boolean isHigh = id % 2 == 1;
        DistributorSide side = this.getSides().get(sideId);
        if (isHigh) {
            side.setHighShortData(data);
        } else {
            side.setLowShortData(data);
        }
    }

    public TileEntityManager[] getInventories() {
        if (this.dirty) {
            this.generateInventories();
            this.dirty = false;
        }
        return this.inventories;
    }

    private void generateInventories() {
        TileEntityManager bot = this.generateManager(-1);
        TileEntityManager top = this.generateManager(1);
        this.hasTop = top != null;
        this.hasBot = bot != null;
        this.inventories = this.populateManagers(top, bot, this.hasTop, this.hasBot);
    }

    private TileEntityManager[] populateManagers(TileEntityManager topElement, TileEntityManager botElement, boolean hasTopElement, boolean hasBotElement) {
        if (!hasTopElement && !hasBotElement) {
            return new TileEntityManager[0];
        }
        if (!hasBotElement) {
            return new TileEntityManager[]{topElement};
        }
        if (!hasTopElement) {
            return new TileEntityManager[]{botElement};
        }
        return new TileEntityManager[]{botElement, topElement};
    }

    private TileEntityManager generateManager(int y) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, y, 0));
        if (te != null && te instanceof TileEntityManager) {
            return (TileEntityManager)te;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    private int translateSlotId(int slot) {
        return slot % 60;
    }

    private TileEntityManager getManagerFromSlotId(int slot) {
        TileEntityManager[] invs = this.getInventories();
        int id = slot / 60;
        if (!this.hasTop || !this.hasBot) {
            id = 0;
        }
        if (id < 0 || id >= invs.length) {
            return null;
        }
        return invs[id];
    }

    public int func_70302_i_() {
        return 120;
    }

    public boolean func_191420_l() {
        return false;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.func_70301_a(this.translateSlotId(slot));
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.func_70298_a(this.translateSlotId(slot), count);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemstack) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            manager.func_70299_a(this.translateSlotId(slot), itemstack);
        }
    }

    public String func_70005_c_() {
        return "container.cargodistributor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        TileEntityManager manager = this.getManagerFromSlotId(slot);
        if (manager != null) {
            return manager.getStackInSlotOnClosing(this.translateSlotId(slot));
        }
        return ItemStack.field_190927_a;
    }

    private boolean isChunkValid(DistributorSide side, TileEntityManager manager, int chunkId, boolean top) {
        for (DistributorSetting setting : DistributorSetting.settings) {
            if (!setting.isEnabled(this) || !side.isSet(setting.getId()) || !setting.isValid(manager, chunkId, top)) continue;
            return true;
        }
        return false;
    }

    private FluidStack drain(EnumFacing from, FluidStack resource, int maxDrain, boolean doDrain) {
        SCTank[] tanks;
        FluidStack ret = resource;
        if (ret != null) {
            ret = ret.copy();
            ret.amount = 0;
        }
        for (SCTank tank : tanks = this.getTanks(from)) {
            FluidStack temp = tank.drain(maxDrain, doDrain);
            if (temp == null || ret != null && !ret.isFluidEqual(temp)) continue;
            if (ret == null) {
                ret = temp;
            } else {
                FluidStack fluidStack = ret;
                fluidStack.amount += temp.amount;
            }
            if ((maxDrain -= temp.amount) <= 0) break;
        }
        if (ret != null && ret.amount == 0) {
            return null;
        }
        return ret;
    }

    private boolean hasAnyTank(EnumFacing facing) {
        return facing != null && this.getInventories().length > 0 && this.getTanks(facing).length > 0;
    }

    private SCTank[] getTanks(EnumFacing direction) {
        TileEntityManager[] invs = this.getInventories();
        if (invs.length > 0) {
            for (DistributorSide side : this.getSides()) {
                if (side.getSide() != direction) continue;
                ArrayList<SCTank> tanks = new ArrayList<SCTank>();
                if (this.hasTop && this.hasBot) {
                    this.populateTanks(tanks, side, invs[0], false);
                    this.populateTanks(tanks, side, invs[1], true);
                } else if (this.hasTop) {
                    this.populateTanks(tanks, side, invs[0], true);
                } else if (this.hasBot) {
                    this.populateTanks(tanks, side, invs[0], false);
                }
                return tanks.toArray(new SCTank[tanks.size()]);
            }
        }
        return new SCTank[0];
    }

    private void populateTanks(ArrayList<SCTank> tanks, DistributorSide side, TileEntityManager manager, boolean top) {
        if (manager != null && manager instanceof TileEntityLiquid) {
            TileEntityLiquid fluid = (TileEntityLiquid)manager;
            SCTank[] managerTanks = fluid.getTanks();
            for (int i = 0; i < 4; ++i) {
                if (!this.isChunkValid(side, manager, i, top) || tanks.contains((Object)managerTanks[i])) continue;
                tanks.add(managerTanks[i]);
            }
        }
    }

    private void populateSlots(ArrayList<Integer> slotchunks, DistributorSide side, TileEntityManager manager, boolean top) {
        if (manager != null && manager instanceof TileEntityCargo) {
            for (int i = 0; i < 4; ++i) {
                int chunkid;
                if (!this.isChunkValid(side, manager, i, top) || slotchunks.contains(chunkid = i + (top ? 4 : 0))) continue;
                slotchunks.add(chunkid);
            }
        }
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack item, EnumFacing side) {
        return true;
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack item, EnumFacing side) {
        return true;
    }

    public boolean func_94041_b(int slotId, @Nonnull ItemStack item) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        TileEntityManager[] invs = this.getInventories();
        if (invs.length > 0) {
            for (DistributorSide otherSide : this.getSides()) {
                if (otherSide.getFacing() != side) continue;
                ArrayList<Integer> slotchunks = new ArrayList<Integer>();
                if (this.hasTop && this.hasBot) {
                    this.populateSlots(slotchunks, otherSide, invs[0], false);
                    this.populateSlots(slotchunks, otherSide, invs[1], true);
                } else if (this.hasTop) {
                    this.populateSlots(slotchunks, otherSide, invs[0], true);
                } else if (this.hasBot) {
                    this.populateSlots(slotchunks, otherSide, invs[0], false);
                }
                int[] ret = new int[slotchunks.size() * 15];
                int id = 0;
                for (int chunkid : slotchunks) {
                    for (int i = 0; i < 15; ++i) {
                        ret[id] = chunkid * 15 + i;
                        ++id;
                    }
                }
                return ret;
            }
        }
        return new int[0];
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.hasAnyTank(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.hasAnyTank(facing)) {
            return (T)this.fluidHandlerMap.get(facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

