/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tetris;

import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.tetris.ArcadeTetris;
import vswe.stevescarts.arcade.tetris.TetrisBlock;
import vswe.stevescarts.arcade.tetris.TetrisPiecePart;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.handlers.SoundHandler;

public class TetrisPiece {
    private TetrisPiecePart[] parts;
    private int x;
    private int y;
    private SoundEvent sound;
    private float volume;
    private int rotationOffset;

    private TetrisPiece(TetrisPiecePart[] parts) {
        this.parts = parts;
        this.x = 5;
        this.y = -2;
    }

    public static TetrisPiece createPiece(int type) {
        SoundEvent sound = null;
        float volume = 0.5f;
        int rotationOffset = 0;
        TetrisPiecePart[] parts = null;
        switch (type) {
            case 0: {
                parts = TetrisPiece.createEndermanParts();
                sound = SoundEvents.field_187531_aU;
                break;
            }
            case 1: {
                parts = TetrisPiece.createSlimeParts();
                sound = SoundEvents.field_187882_fq;
                rotationOffset = 1;
                break;
            }
            case 2: {
                parts = TetrisPiece.createWitherParts();
                sound = SoundEvents.field_187851_gB;
                volume = 0.25f;
                break;
            }
            case 3: {
                parts = TetrisPiece.createWitchParts();
                sound = SoundEvents.field_187642_Q;
                break;
            }
            case 4: {
                parts = TetrisPiece.createPigParts();
                sound = SoundEvents.field_187697_dL;
                break;
            }
            case 5: {
                parts = TetrisPiece.createSteveParts();
                sound = SoundEvents.field_187800_eb;
                break;
            }
            case 6: {
                parts = TetrisPiece.createSheepParts();
                sound = SoundEvents.field_187757_eG;
                break;
            }
            default: {
                return null;
            }
        }
        TetrisPiece piece = new TetrisPiece(parts);
        piece.sound = sound;
        piece.rotationOffset = rotationOffset;
        piece.volume = volume;
        return piece;
    }

    private static TetrisPiecePart[] createEndermanParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(0, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(0, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(0, 20), 0, 1), new TetrisPiecePart(new TetrisBlock(0, 30), 0, 2)};
        return parts;
    }

    private static TetrisPiecePart[] createSlimeParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(10, 0), 0, 0), new TetrisPiecePart(new TetrisBlock(20, 0), 1, 0), new TetrisPiecePart(new TetrisBlock(10, 10), 0, 1), new TetrisPiecePart(new TetrisBlock(20, 10), 1, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createWitherParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(30, 0), -1, 0), new TetrisPiecePart(new TetrisBlock(40, 0), 0, 0), new TetrisPiecePart(new TetrisBlock(50, 0), 1, 0), new TetrisPiecePart(new TetrisBlock(40, 10), 0, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createWitchParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(70, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(70, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(70, 20), 0, 1), new TetrisPiecePart(new TetrisBlock(60, 20), -1, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createPigParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(80, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(80, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(80, 20), 0, 1), new TetrisPiecePart(new TetrisBlock(90, 20), 1, 1)};
        return parts;
    }

    private static TetrisPiecePart[] createSteveParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(100, 0), -1, -1), new TetrisPiecePart(new TetrisBlock(110, 0), 0, -1), new TetrisPiecePart(new TetrisBlock(110, 10), 0, 0), new TetrisPiecePart(new TetrisBlock(120, 10), 1, 0)};
        return parts;
    }

    private static TetrisPiecePart[] createSheepParts() {
        TetrisPiecePart[] parts = new TetrisPiecePart[]{new TetrisPiecePart(new TetrisBlock(130, 10), -1, 1), new TetrisPiecePart(new TetrisBlock(140, 10), 0, 1), new TetrisPiecePart(new TetrisBlock(140, 0), 0, 0), new TetrisPiecePart(new TetrisBlock(150, 0), 1, 0)};
        return parts;
    }

    public void render(ArcadeTetris game, GuiMinecart gui) {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].render(game, gui, this.x, this.y);
        }
    }

    public void rotate(TetrisBlock[][] board) {
        int i;
        for (i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].canRotate(board, this.x, this.y, this.rotationOffset)) continue;
            return;
        }
        for (i = 0; i < this.parts.length; ++i) {
            this.parts[i].rotate(this.rotationOffset);
        }
    }

    public MOVE_RESULT move(ArcadeTetris game, TetrisBlock[][] board, int offX, int offY, boolean placeOnFail) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].canMoveTo(board, this.x + offX, this.y + offY)) continue;
            boolean isGameOver = false;
            if (placeOnFail) {
                for (int j = 0; j < this.parts.length; ++j) {
                    if (this.parts[j].canPlaceInBoard(this.y)) {
                        this.parts[j].placeInBoard(board, this.x, this.y);
                        continue;
                    }
                    isGameOver = true;
                }
                if (SCConfig.useArcadeMobSounds) {
                    if (this.sound != null) {
                        ArcadeGame.playSound(this.sound, this.volume, (game.getModule().getCart().field_70146_Z.nextFloat() - game.getModule().getCart().field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    ArcadeGame.playSound(SoundHandler.BOOP, 1.0f, 1.0f);
                }
            }
            return isGameOver ? MOVE_RESULT.GAME_OVER : MOVE_RESULT.FAIL;
        }
        this.x += offX;
        this.y += offY;
        return MOVE_RESULT.SUCCESS;
    }

    public static enum MOVE_RESULT {
        SUCCESS,
        FAIL,
        GAME_OVER;

    }
}

