/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import reborncore.common.network.RegisterPacketEvent;
import vswe.stevescarts.CommonProxy;
import vswe.stevescarts.Constants;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.entitys.CartDataSerializers;
import vswe.stevescarts.entitys.EntityCake;
import vswe.stevescarts.entitys.EntityEasterEgg;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.handlers.EventHandler;
import vswe.stevescarts.handlers.EventHandlerChristmas;
import vswe.stevescarts.handlers.TradeHandler;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.helpers.CreativeTabSC2;
import vswe.stevescarts.helpers.GiftItem;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.packet.PacketFluidSync;
import vswe.stevescarts.packet.PacketReturnCart;
import vswe.stevescarts.packet.PacketStevesCarts;
import vswe.stevescarts.plugins.PluginLoader;
import vswe.stevescarts.upgrades.AssemblerUpgrade;

@Mod(modid="stevescarts", name="Steve's Carts 2", version="2.4.22.109", dependencies="required-after:reborncore;required-after:forge@[14.21.0.2373,);", acceptedMinecraftVersions="[1.12,1.12.2]")
public class StevesCarts {
    @SidedProxy(clientSide="vswe.stevescarts.ClientProxy", serverSide="vswe.stevescarts.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="stevescarts")
    public static StevesCarts instance;
    public static CreativeTabSC2 tabsSC2;
    public static CreativeTabSC2 tabsSC2Components;
    public static CreativeTabSC2 tabsSC2Blocks;
    public static Logger logger;
    public TradeHandler tradeHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ModuleData.init();
        SCConfig.INSTANCE.load(event);
        ModItems.preInit();
        ModBlocks.preInit();
        AssemblerUpgrade.init();
        this.initCart(0, EntityMinecartModular.class);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("stevescarts", "egg"), EntityEasterEgg.class, (String)"Egg.Vswe", (int)2, (Object)instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("stevescarts", "cake"), EntityCake.class, (String)"Cake.Vswe", (int)3, (Object)instance, (int)80, (int)3, (boolean)true);
        proxy.preInit();
        StevesCarts.registerFenceOreDict();
        PluginLoader.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        if (Constants.isChristmas) {
            this.tradeHandler = new TradeHandler();
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerChristmas());
        }
        GiftItem.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.init();
        tabsSC2.setIcon(ModuleData.getList().get((byte)39).getItemStack());
        tabsSC2Components.setIcon(ComponentTypes.REINFORCED_WHEELS.getItemStack());
        tabsSC2Blocks.setIcon(new ItemStack(ModBlocks.CART_ASSEMBLER.getBlock(), 1));
        TileEntityCargo.loadSelectionSettings();
        ModItems.addRecipes();
        CartDataSerializers.init();
        PluginLoader.init(evt);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.loadComplete();
    }

    private void initCart(int ID, Class<? extends EntityMinecartModular> cart) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("stevescarts", "cart." + ID), cart, (String)("Minecart.Vswe." + ID), (int)ID, (Object)instance, (int)80, (int)3, (boolean)true);
    }

    private static void registerFenceOreDict() {
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180407_aO);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180408_aP);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180404_aQ);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180403_aR);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180406_aS);
        OreDictionary.registerOre((String)"fenceWood", (Block)Blocks.field_180405_aT);
    }

    @SubscribeEvent
    public void registerPackets(RegisterPacketEvent event) {
        event.registerPacket(PacketStevesCarts.class, Side.CLIENT);
        event.registerPacket(PacketStevesCarts.class, Side.SERVER);
        event.registerPacket(PacketFluidSync.class, Side.CLIENT);
        event.registerPacket(PacketReturnCart.class, Side.SERVER);
    }

    static {
        tabsSC2 = new CreativeTabSC2("SC2Modules");
        tabsSC2Components = new CreativeTabSC2("SC2Items");
        tabsSC2Blocks = new CreativeTabSC2("SC2Blocks");
    }

    public static class ModuleEnabled
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            int id = JsonUtils.func_151203_m((JsonObject)json, (String)"id");
            ModuleData data = ModuleData.getList().get((byte)id);
            if (!data.getIsLocked() && SCConfig.validModules.get(data.getID()).booleanValue()) {
                return () -> true;
            }
            return () -> false;
        }
    }

    public static class IsEvent
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"event");
            if ("christmas".equals(name) && Constants.isChristmas || "easter".equals(name) && Constants.isEaster || "halloween".equals(name) && Constants.isHalloween) {
                return () -> true;
            }
            return () -> false;
        }
    }
}

