/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TCuboidPart;
import codechicken.multipart.TIconHitEffectsPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TNormalOcclusionPart;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;

public abstract class McBlockPart
extends TMultiPart
implements TCuboidPart,
TNormalOcclusionPart,
TIconHitEffectsPart {
    public abstract Block getBlock();

    @Override
    public Iterable<IndexedCuboid6> getSubParts() {
        return Arrays.asList(new IndexedCuboid6((Object)0, this.getBounds()));
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        return Collections.emptyList();
    }

    @Override
    public void renderBreaking(Vector3 pos, TextureAtlasSprite texture, CCRenderState ccrs) {
        ccrs.setPipeline(new IVertexOperation[]{pos.translation(), new IconTransformation(texture)});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)this.getBounds(), (int)0);
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply(this, npart);
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getDropStack());
    }

    @Override
    public ItemStack pickItem(CuboidRayTraceResult hit) {
        return this.getDropStack();
    }

    public ItemStack getDropStack() {
        return new ItemStack(this.getBlock());
    }
}

