/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.RayTracer;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McMultipartSPH;
import codechicken.multipart.minecraft.McSidedMetaPart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    private ThreadLocal<Object> placing = new ThreadLocal();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            if (EventHandler.place(event.getEntityPlayer(), event.getHand(), event.getEntityPlayer().field_70170_p)) {
                event.setCanceled(true);
            }
            this.placing.set(null);
        }
    }

    public static boolean place(EntityPlayer player, EnumHand hand, World world) {
        RayTraceResult hit = RayTracer.retrace((EntityPlayer)player);
        if (hit == null) {
            return false;
        }
        BlockPos pos = new BlockPos((Vec3i)hit.func_178782_a()).func_177972_a(hit.field_178784_b);
        ItemStack held = player.func_184586_b(hand);
        McSidedMetaPart part = null;
        if (held.func_190926_b()) {
            return false;
        }
        Block heldBlock = Block.func_149634_a((Item)held.func_77973_b());
        if (heldBlock == null) {
            return false;
        }
        if (heldBlock == Blocks.field_150478_aa) {
            part = new TorchPart();
        } else if (heldBlock == Blocks.field_150442_at) {
            part = new LeverPart();
        } else if (heldBlock == Blocks.field_150430_aB || heldBlock == Blocks.field_150471_bO) {
            part = new ButtonPart();
        } else if (heldBlock == Blocks.field_150429_aA) {
            part = new RedstoneTorchPart();
        }
        if (part == null) {
            return false;
        }
        part.setStateOnPlacement(world, pos, hit.field_178784_b, hit.field_72307_f, (EntityLivingBase)player, held);
        TileMultipart tile = TileMultipart.getOrConvertTile(world, pos);
        if (tile == null || !tile.canAddPart(part)) {
            return false;
        }
        if (!world.field_72995_K) {
            TileMultipart.addPart(world, pos, part);
            SoundType sound = part.getBlock().func_185467_w();
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
                if (held.func_190916_E() == 0) {
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held, hand));
                }
            }
        } else {
            player.func_184609_a(hand);
            new PacketCustom(McMultipartSPH.channel, 1).writeBoolean(hand == EnumHand.MAIN_HAND).sendToServer();
        }
        return true;
    }
}

