/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import reborncore.common.util.ItemUtils;

public class FluidUtils {
    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        IFluidHandlerItem inputFluidHandler = FluidUtils.getFluidHandler(input);
        if (inputFluidHandler != null && FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)inputFluidHandler, (int)inputFluidHandler.getTankProperties()[0].getCapacity(), (boolean)false) != null) {
            FluidStack drained = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)inputFluidHandler, (int)inputFluidHandler.getTankProperties()[0].getCapacity(), (boolean)true);
            if (drained != null && !inputFluidHandler.getContainer().func_190926_b()) {
                if (output.func_190926_b()) {
                    inv.func_70299_a(outputSlot, inputFluidHandler.getContainer());
                    inv.func_70298_a(inputSlot, 1);
                } else if (ItemUtils.isItemEqual(output, inputFluidHandler.getContainer(), true, true) && output.func_190916_E() <= output.func_77976_d()) {
                    inv.func_70301_a(outputSlot).func_190920_e(inv.func_70301_a(outputSlot).func_190916_E() + 1);
                    inv.func_70298_a(inputSlot, 1);
                } else {
                    FluidUtil.tryFluidTransfer((IFluidHandler)inputFluidHandler, (IFluidHandler)fluidHandler, (int)drained.amount, (boolean)true);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (!input.func_190926_b()) {
            IFluidHandlerItem inputFluidHandler = FluidUtils.getFluidHandler(input);
            ItemStack containerCopy = input.func_77946_l();
            containerCopy.func_190920_e(1);
            if (inputFluidHandler != null && (output.func_190926_b() || output.func_190916_E() < output.func_77976_d() && ItemUtils.isItemEqual(FluidUtils.getFilledContainer(fluidToFill, containerCopy), output, true, true)) && FluidUtil.tryFluidTransfer((IFluidHandler)inputFluidHandler, (IFluidHandler)fluidHandler, (int)inputFluidHandler.getTankProperties()[0].getCapacity(), (boolean)false) != null) {
                FluidUtil.tryFluidTransfer((IFluidHandler)inputFluidHandler, (IFluidHandler)fluidHandler, (int)inputFluidHandler.getTankProperties()[0].getCapacity(), (boolean)true);
                if (output.func_190926_b()) {
                    inv.func_70299_a(outputSlot, inputFluidHandler.getContainer());
                } else {
                    inv.func_70301_a(outputSlot).func_190920_e(inv.func_70301_a(outputSlot).func_190916_E() + 1);
                }
                inv.func_70298_a(inputSlot, 1);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandler(ItemStack container) {
        ItemStack copy = container.func_77946_l();
        copy.func_190920_e(1);
        return FluidUtil.getFluidHandler((ItemStack)copy);
    }

    @Nullable
    public static FluidStack getFluidStackInContainer(@Nonnull ItemStack container) {
        if (!container.func_190926_b()) {
            container = container.func_77946_l();
            container.func_190920_e(1);
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
            if (fluidHandler != null) {
                return fluidHandler.drain(1000, false);
            }
        }
        return null;
    }

    @Nonnull
    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null || empty.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        fluidHandler.fill(new FluidStack(fluid, fluidHandler.getTankProperties()[0].getCapacity()), true);
        return empty;
    }
}

