/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.registration;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import reborncore.RebornCore;
import reborncore.common.registration.IRegistryFactory;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.RegistryTarget;

public class RegistrationManager {
    static List<IRegistryFactory> factoryList = new ArrayList<IRegistryFactory>();
    static List<Class> registryClasses = new ArrayList<Class>();

    public static void init(FMLPreInitializationEvent event) {
        long start = System.currentTimeMillis();
        ASMDataTable asmDataTable = event.getAsmData();
        RegistrationManager.loadFactorys(asmDataTable);
        Set asmDataSet = asmDataTable.getAll(RebornRegistry.class.getName());
        ArrayList<ASMDataTable.ASMData> asmDataList = new ArrayList<ASMDataTable.ASMData>(asmDataSet);
        asmDataList.sort(Comparator.comparingInt(RegistrationManager::getPriority));
        for (ASMDataTable.ASMData data : asmDataList) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (RegistrationManager.isEarlyReg(data)) {
                    RegistrationManager.handleClass(clazz, null);
                    continue;
                }
                registryClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        registryClasses.sort(Comparator.comparing(Class::getCanonicalName));
        RebornCore.logHelper.info("Pre loaded registries in" + (System.currentTimeMillis() - start) + "ms");
    }

    private static int getPriority(ASMDataTable.ASMData asmData) {
        if (asmData.getAnnotationInfo().containsKey("priority")) {
            return -((Integer)asmData.getAnnotationInfo().get("priority")).intValue();
        }
        return 0;
    }

    private static boolean isEarlyReg(ASMDataTable.ASMData asmData) {
        if (asmData.getAnnotationInfo().containsKey("earlyReg")) {
            return (Boolean)asmData.getAnnotationInfo().get("earlyReg");
        }
        return false;
    }

    public static void load(FMLStateEvent event) {
        long start = System.currentTimeMillis();
        ModContainer activeMod = Loader.instance().activeModContainer();
        List<IRegistryFactory> factoryList = RegistrationManager.getFactorysForSate(event.getClass());
        if (!factoryList.isEmpty()) {
            for (Class clazz : registryClasses) {
                RegistrationManager.handleClass(clazz, activeMod);
            }
            factoryList.forEach(IRegistryFactory::factoryComplete);
            RegistrationManager.setActiveModContainer(activeMod);
        }
        RebornCore.logHelper.info("Loaded registrys for " + event.getClass().getName() + " in " + (System.currentTimeMillis() - start) + "ms");
    }

    private static void handleClass(Class clazz, ModContainer activeMod) {
        RebornRegistry annotation = (RebornRegistry)RegistrationManager.getAnnoation(clazz.getAnnotations(), RebornRegistry.class);
        if (annotation != null && activeMod != null && !activeMod.getModId().equals(annotation.modID())) {
            RegistrationManager.setActiveMod(annotation.modID());
        }
        for (IRegistryFactory regFactory : factoryList) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!regFactory.getTargets().contains((Object)RegistryTarget.FIELD) || !field.isAnnotationPresent(regFactory.getAnnotation())) continue;
                regFactory.handleField(field);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (!regFactory.getTargets().contains((Object)RegistryTarget.MEHTOD) || !accessibleObject.isAnnotationPresent(regFactory.getAnnotation())) continue;
                regFactory.handleMethod((Method)accessibleObject);
            }
            if (!regFactory.getTargets().contains((Object)RegistryTarget.CLASS) || !clazz.isAnnotationPresent(regFactory.getAnnotation())) continue;
            regFactory.handleClass(clazz);
        }
    }

    private static List<IRegistryFactory> getFactorysForSate(Class<? extends FMLStateEvent> event) {
        return factoryList.stream().filter(iRegistryFactory -> iRegistryFactory.getProcessSate() == event).collect(Collectors.toList());
    }

    public static Annotation getAnnoationFromArray(Annotation[] annotations, IRegistryFactory factory) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != factory.getAnnotation()) continue;
            return annotation;
        }
        return null;
    }

    public static Annotation getAnnoation(Annotation[] annotations, Class annoation) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annoation) continue;
            return annotation;
        }
        return null;
    }

    private static void loadFactorys(ASMDataTable dataTable) {
        Set asmDataSet = dataTable.getAll(IRegistryFactory.RegistryFactory.class.getName());
        for (ASMDataTable.ASMData data : asmDataSet) {
            try {
                Object object;
                Class<?> clazz = Class.forName(data.getClassName());
                IRegistryFactory.RegistryFactory registryFactory = (IRegistryFactory.RegistryFactory)RegistrationManager.getAnnoation(clazz.getAnnotations(), IRegistryFactory.RegistryFactory.class);
                if (!registryFactory.side().canExcetue() || !Loader.isModLoaded((String)registryFactory.modID()) || !((object = clazz.newInstance()) instanceof IRegistryFactory)) continue;
                IRegistryFactory factory = (IRegistryFactory)object;
                factoryList.add(factory);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setActiveMod(String modID) {
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (!modContainer.getModId().equals(modID)) continue;
            RegistrationManager.setActiveModContainer(modContainer);
            break;
        }
    }

    private static void setActiveModContainer(ModContainer container) {
        Loader.instance().setActiveModContainer(container);
    }
}

