/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.RebornCore;
import reborncore.api.tile.IContainerLayout;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotFake;

public abstract class RebornContainer
extends Container {
    private static HashMap<String, RebornContainer> containerMap = new HashMap();
    public HashMap<Integer, BaseSlot> slotMap = new HashMap();
    private Optional<TileEntity> baseTile = Optional.empty();

    @Deprecated
    public RebornContainer() {
    }

    public RebornContainer(TileEntity tileEntity) {
        this.baseTile = Optional.of(tileEntity);
    }

    @Nullable
    public static RebornContainer getContainerFromClass(Class<? extends RebornContainer> clazz, TileEntity tileEntity) {
        return RebornContainer.createContainer(clazz, tileEntity, RebornCore.proxy.getPlayer());
    }

    public static RebornContainer createContainer(Class<? extends RebornContainer> clazz, TileEntity tileEntity, EntityPlayer player) {
        if (player == null && containerMap.containsKey(clazz.getCanonicalName())) {
            return containerMap.get(clazz.getCanonicalName());
        }
        try {
            RebornContainer container = null;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterCount() == 0) {
                    container = clazz.newInstance();
                    if (!(container instanceof IContainerLayout)) continue;
                    ((IContainerLayout)((Object)container)).setTile(tileEntity);
                    ((IContainerLayout)((Object)container)).addInventorySlots();
                    continue;
                }
                if (constructor.getParameterCount() != 2) continue;
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes[0].isInstance(tileEntity) && paramTypes[1] == EntityPlayer.class) {
                    container = clazz.getDeclaredConstructor(tileEntity.getClass(), EntityPlayer.class).newInstance(tileEntity, player);
                    continue;
                }
                if (paramTypes[0] != EntityPlayer.class || !paramTypes[1].isInstance(tileEntity)) continue;
                container = clazz.getDeclaredConstructor(EntityPlayer.class, tileEntity.getClass()).newInstance(player, tileEntity);
            }
            if (container == null) {
                RebornCore.logHelper.error("Failed to create container for " + clazz.getName() + " bad things may happen, please report to devs");
            }
            containerMap.put(clazz.getCanonicalName(), container);
            return container;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    protected Slot func_75146_a(Slot slotIn) {
        Slot slot = super.func_75146_a(slotIn);
        if (slot instanceof BaseSlot) {
            this.slotMap.put(slot.getSlotIndex(), (BaseSlot)slot);
        }
        return slot;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == originalStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                int max;
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot.func_190926_b() || !RebornContainer.canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.func_190916_E() + stackToShift.func_190916_E();
                if (resultingStackSize <= (max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a()))) {
                    stackToShift.func_190920_e(0);
                    stackInSlot.func_190920_e(resultingStackSize);
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.func_190916_E() >= max) continue;
                stackToShift.func_190920_e(stackToShift.func_190916_E() - (max - stackInSlot.func_190916_E()));
                stackInSlot.func_190920_e(max);
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.func_190916_E() > 0) {
            for (slotIndex = start; stackToShift.func_190916_E() > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (!stackInSlot.func_190926_b()) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.func_190920_e(Math.min(stackToShift.func_190916_E(), max));
                stackToShift.func_190920_e(stackToShift.func_190916_E() - stackInSlot.func_190916_E());
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (slot instanceof SlotFake || !slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public void addPlayersHotbar(EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 142));
        }
    }

    public void addPlayersInventory(EntityPlayer player) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    public void drawPlayersInv(EntityPlayer player) {
        this.drawPlayersInv(player, 8, 81);
    }

    public void drawPlayersHotBar(EntityPlayer player) {
        this.drawPlayersHotBar(player, 8, 139);
    }

    public void drawPlayersInv(EntityPlayer player, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new BaseSlot((IInventory)player.field_71071_by, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
    }

    public void drawPlayersHotBar(EntityPlayer player, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new BaseSlot((IInventory)player.field_71071_by, i, x + i * 18, y));
        }
    }

    public void drawPlayersInvAndHotbar(EntityPlayer player) {
        this.drawPlayersInv(player);
        this.drawPlayersHotBar(player);
    }

    public void drawPlayersInvAndHotbar(EntityPlayer player, int x, int y) {
        this.drawPlayersInv(player, x, y);
        this.drawPlayersHotBar(player, x, y + 58);
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.baseTile.isPresent()) {
            BlockPos pos;
            World world = player.func_130014_f_();
            return world.func_175625_s(pos = this.baseTile.get().func_174877_v()) == this.baseTile.get() && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }
        return true;
    }
}

