/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.network.packets.CheckUpdatePKT;
import moze_intel.projecte.network.packets.CooldownResetPKT;
import moze_intel.projecte.network.packets.KeyPressPKT;
import moze_intel.projecte.network.packets.KnowledgeClearPKT;
import moze_intel.projecte.network.packets.KnowledgeSyncPKT;
import moze_intel.projecte.network.packets.LeftClickArchangelPKT;
import moze_intel.projecte.network.packets.SearchUpdatePKT;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.network.packets.SyncBagDataPKT;
import moze_intel.projecte.network.packets.SyncCovalencePKT;
import moze_intel.projecte.network.packets.SyncEmcPKT;
import moze_intel.projecte.network.packets.UpdateGemModePKT;
import moze_intel.projecte.network.packets.UpdateWindowIntPKT;
import moze_intel.projecte.network.packets.UpdateWindowLongPKT;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class PacketHandler {
    private static final SimpleNetworkWrapper HANDLER = NetworkRegistry.INSTANCE.newSimpleChannel("projecte");

    public static void register() {
        int disc = 0;
        HANDLER.registerMessage(SyncEmcPKT.Handler.class, SyncEmcPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(KeyPressPKT.Handler.class, KeyPressPKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(StepHeightPKT.Handler.class, StepHeightPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(SetFlyPKT.Handler.class, SetFlyPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(KnowledgeSyncPKT.Handler.class, KnowledgeSyncPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(CheckUpdatePKT.Handler.class, CheckUpdatePKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(SyncBagDataPKT.Handler.class, SyncBagDataPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(SearchUpdatePKT.Handler.class, SearchUpdatePKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(KnowledgeClearPKT.Handler.class, KnowledgeClearPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(UpdateGemModePKT.Handler.class, UpdateGemModePKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(UpdateWindowIntPKT.Handler.class, UpdateWindowIntPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(UpdateWindowLongPKT.Handler.class, UpdateWindowLongPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(CooldownResetPKT.Handler.class, CooldownResetPKT.class, disc++, Side.CLIENT);
        HANDLER.registerMessage(LeftClickArchangelPKT.Handler.class, LeftClickArchangelPKT.class, disc++, Side.SERVER);
        HANDLER.registerMessage(SyncCovalencePKT.Handler.class, SyncCovalencePKT.class, disc++, Side.CLIENT);
    }

    public static void sendProgressBarUpdateInt(IContainerListener listener, Container container, int propId, int propVal) {
        if (listener instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new UpdateWindowIntPKT((short)container.field_75152_c, (short)propId, propVal), (EntityPlayerMP)listener);
        }
    }

    public static void sendProgressBarUpdateLong(IContainerListener listener, Container container, int propId, long propVal) {
        if (listener instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new UpdateWindowLongPKT((short)container.field_75152_c, (short)propId, propVal), (EntityPlayerMP)listener);
        }
    }

    public static void sendNonLocal(IMessage msg, EntityPlayerMP player) {
        if (player.field_71133_b.func_71262_S() || !player.func_70005_c_().equals(player.field_71133_b.func_71214_G())) {
            HANDLER.sendTo(msg, player);
        }
    }

    public static void sendFragmentedEmcPacket(EntityPlayerMP player) {
        PacketHandler.sendNonLocal(new SyncEmcPKT(PacketHandler.serializeEmcData()), player);
    }

    public static void sendFragmentedEmcPacketToAll() {
        SyncEmcPKT pkt = new SyncEmcPKT(PacketHandler.serializeEmcData());
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            PacketHandler.sendNonLocal(pkt, player);
        }
    }

    private static SyncEmcPKT.EmcPKTInfo[] serializeEmcData() {
        SyncEmcPKT.EmcPKTInfo[] ret = new SyncEmcPKT.EmcPKTInfo[EMCMapper.emc.size()];
        int i = 0;
        for (Map.Entry<SimpleStack, Long> entry : EMCMapper.emc.entrySet()) {
            SimpleStack stack = entry.getKey();
            int id = Item.field_150901_e.func_148757_b(Item.field_150901_e.func_82594_a((Object)stack.id));
            ret[i] = new SyncEmcPKT.EmcPKTInfo(id, stack.damage, entry.getValue());
            ++i;
        }
        PECore.debugLog("EMC data size: {} bytes", ret.length * 16);
        return ret;
    }

    public static void sendToServer(IMessage msg) {
        HANDLER.sendToServer(msg);
    }

    public static void sendToAll(IMessage msg) {
        HANDLER.sendToAll(msg);
    }

    public static void sendToAllAround(IMessage msg, NetworkRegistry.TargetPoint point) {
        HANDLER.sendToAllAround(msg, point);
    }

    public static void sendTo(IMessage msg, EntityPlayerMP player) {
        if (!(player instanceof FakePlayer)) {
            HANDLER.sendTo(msg, player);
        }
    }

    public static void sendToDimension(IMessage msg, int dimension) {
        HANDLER.sendToDimension(msg, dimension);
    }
}

