/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcProvider;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK2Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK3Tile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CollectorMK1Tile
extends TileEmc
implements IEmcProvider {
    private final ItemStackHandler input = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler auxSlots = new TileEmc.StackHandler(this, 3);
    private final CombinedInvWrapper toSort = new CombinedInvWrapper(new IItemHandlerModifiable[]{new RangedWrapper((IItemHandlerModifiable)this.auxSlots, 0, 1), this.input});
    private final IItemHandler automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SlotPredicates.COLLECTOR_INV.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private final IItemHandler automationAuxSlots = new WrappedItemHandler((IItemHandlerModifiable)this.auxSlots, WrappedItemHandler.WriteMode.OUT){

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            if (slot == 1) {
                return super.extractItem(slot, count, simulate);
            }
            return ItemStack.field_190927_a;
        }
    };
    public static final int UPGRADING_SLOT = 0;
    public static final int UPGRADE_SLOT = 1;
    public static final int LOCK_SLOT = 2;
    private final int emcGen;
    private boolean hasChargeableItem;
    private boolean hasFuel;
    private double storedFuelEmc;

    public CollectorMK1Tile() {
        super(10000);
        this.emcGen = 4;
    }

    public CollectorMK1Tile(int maxEmc, int emcGen) {
        super(maxEmc);
        this.emcGen = emcGen;
    }

    public IItemHandler getInput() {
        return this.input;
    }

    public IItemHandler getAux() {
        return this.auxSlots;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null && side.func_176740_k().func_176720_b()) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationAuxSlots);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationInput);
        }
        return (T)super.getCapability(cap, side);
    }

    protected int getInvSize() {
        return 8;
    }

    private ItemStack getUpgraded() {
        return this.auxSlots.getStackInSlot(1);
    }

    private ItemStack getLock() {
        return this.auxSlots.getStackInSlot(2);
    }

    private ItemStack getUpgrading() {
        return this.auxSlots.getStackInSlot(0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemHelper.compactInventory((IItemHandlerModifiable)this.toSort);
        this.checkFuelOrKlein();
        this.updateEmc();
        this.rotateUpgraded();
    }

    private void rotateUpgraded() {
        if (!this.getUpgraded().func_190926_b() && (this.getLock().func_190926_b() || this.getUpgraded().func_77973_b() != this.getLock().func_77973_b() || this.getUpgraded().func_190916_E() >= this.getUpgraded().func_77976_d())) {
            this.auxSlots.setStackInSlot(1, ItemHandlerHelper.insertItemStacked((IItemHandler)this.input, (ItemStack)this.getUpgraded().func_77946_l(), (boolean)false));
        }
    }

    private void checkFuelOrKlein() {
        if (!this.getUpgrading().func_190926_b() && this.getUpgrading().func_77973_b() instanceof IItemEmc) {
            IItemEmc itemEmc = (IItemEmc)this.getUpgrading().func_77973_b();
            if (itemEmc.getStoredEmc(this.getUpgrading()) != itemEmc.getMaximumEmc(this.getUpgrading())) {
                this.hasChargeableItem = true;
                this.hasFuel = false;
            } else {
                this.hasChargeableItem = false;
            }
        } else if (!this.getUpgrading().func_190926_b()) {
            this.hasFuel = true;
            this.hasChargeableItem = false;
        } else {
            this.hasFuel = false;
            this.hasChargeableItem = false;
        }
    }

    private void updateEmc() {
        if (!this.hasMaxedEmc()) {
            this.addEMC(this.getSunRelativeEmc(this.emcGen) / 20.0f);
        }
        if (this.getStoredEmc() == 0.0) {
            return;
        }
        if (this.hasChargeableItem) {
            double maxItemEmc;
            double toSend = this.getStoredEmc() < (double)this.emcGen ? this.getStoredEmc() : (double)this.emcGen;
            IItemEmc item = (IItemEmc)this.getUpgrading().func_77973_b();
            double itemEmc = item.getStoredEmc(this.getUpgrading());
            if (itemEmc + toSend > (maxItemEmc = item.getMaximumEmc(this.getUpgrading()))) {
                toSend = maxItemEmc - itemEmc;
            }
            item.addEmc(this.getUpgrading(), toSend);
            this.removeEMC(toSend);
        } else if (this.hasFuel) {
            ItemStack result;
            long upgradeCost;
            if (FuelMapper.getFuelUpgrade(this.getUpgrading()).func_190926_b()) {
                this.auxSlots.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if ((upgradeCost = EMCHelper.getEmcValue(result = this.getLock().func_190926_b() ? FuelMapper.getFuelUpgrade(this.getUpgrading()) : this.getLock().func_77946_l()) - EMCHelper.getEmcValue(this.getUpgrading())) > 0L && this.getStoredEmc() >= (double)upgradeCost) {
                ItemStack upgrade = this.getUpgraded();
                if (this.getUpgraded().func_190926_b()) {
                    this.removeEMC(upgradeCost);
                    this.auxSlots.setStackInSlot(1, result);
                    this.getUpgrading().func_190918_g(1);
                } else if (ItemHelper.basicAreStacksEqual(result, upgrade) && upgrade.func_190916_E() < upgrade.func_77976_d()) {
                    this.removeEMC(upgradeCost);
                    this.getUpgraded().func_190917_f(1);
                    this.getUpgrading().func_190918_g(1);
                }
            }
        } else {
            double toSend = this.getStoredEmc() < (double)this.emcGen ? this.getStoredEmc() : (double)this.emcGen;
            this.sendToAllAcceptors(toSend);
            this.sendRelayBonus();
        }
    }

    private float getSunRelativeEmc(int emc) {
        return (float)this.getSunLevel() * (float)emc / 16.0f;
    }

    public double getEmcToNextGoal() {
        if (!this.getLock().func_190926_b()) {
            return EMCHelper.getEmcValue(this.getLock()) - EMCHelper.getEmcValue(this.getUpgrading());
        }
        return EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(this.getUpgrading())) - EMCHelper.getEmcValue(this.getUpgrading());
    }

    public double getItemCharge() {
        if (!this.getUpgrading().func_190926_b() && this.getUpgrading().func_77973_b() instanceof IItemEmc) {
            return ((IItemEmc)this.getUpgrading().func_77973_b()).getStoredEmc(this.getUpgrading());
        }
        return -1.0;
    }

    public double getItemChargeProportion() {
        double charge = this.getItemCharge();
        if (this.getUpgrading().func_190926_b() || charge <= 0.0 || !(this.getUpgrading().func_77973_b() instanceof IItemEmc)) {
            return -1.0;
        }
        return charge / ((IItemEmc)this.getUpgrading().func_77973_b()).getMaximumEmc(this.getUpgrading());
    }

    public int getSunLevel() {
        if (this.field_145850_b.field_73011_w.func_177500_n()) {
            return 16;
        }
        return this.field_145850_b.func_175699_k(this.func_174877_v().func_177984_a()) + 1;
    }

    public double getFuelProgress() {
        long reqEmc;
        if (this.getUpgrading().func_190926_b() || !FuelMapper.isStackFuel(this.getUpgrading())) {
            return 0.0;
        }
        if (!this.getLock().func_190926_b()) {
            reqEmc = EMCHelper.getEmcValue(this.getLock()) - EMCHelper.getEmcValue(this.getUpgrading());
            if (reqEmc < 0L) {
                return 0.0;
            }
        } else {
            if (FuelMapper.getFuelUpgrade(this.getUpgrading()).func_190926_b()) {
                this.auxSlots.setStackInSlot(0, ItemStack.field_190927_a);
                return 0.0;
            }
            reqEmc = EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(this.getUpgrading())) - EMCHelper.getEmcValue(this.getUpgrading());
        }
        if (this.getStoredEmc() >= (double)reqEmc) {
            return 1.0;
        }
        return this.getStoredEmc() / (double)reqEmc;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storedFuelEmc = nbt.func_74769_h("FuelEMC");
        this.input.deserializeNBT(nbt.func_74775_l("Input"));
        this.auxSlots.deserializeNBT(nbt.func_74775_l("AuxSlots"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74780_a("FuelEMC", this.storedFuelEmc);
        nbt.func_74782_a("Input", (NBTBase)this.input.serializeNBT());
        nbt.func_74782_a("AuxSlots", (NBTBase)this.auxSlots.serializeNBT());
        return nbt;
    }

    private void sendRelayBonus() {
        for (Map.Entry<EnumFacing, TileEntity> entry : WorldHelper.getAdjacentTileEntitiesMapped(this.field_145850_b, this).entrySet()) {
            EnumFacing dir = entry.getKey();
            TileEntity tile = entry.getValue();
            if (tile instanceof RelayMK3Tile) {
                ((RelayMK3Tile)tile).acceptEMC(dir, 0.5);
                continue;
            }
            if (tile instanceof RelayMK2Tile) {
                ((RelayMK2Tile)tile).acceptEMC(dir, 0.15);
                continue;
            }
            if (!(tile instanceof RelayMK1Tile)) continue;
            ((RelayMK1Tile)tile).acceptEMC(dir, 0.05);
        }
    }

    @Override
    public double provideEMC(@Nonnull EnumFacing side, double toExtract) {
        double toRemove = Math.min(this.currentEMC, toExtract);
        this.removeEMC(toRemove);
        return toRemove;
    }
}

