/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBlock;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.MystEmptyChunk;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class WorldProviderMystDummy
extends WorldProviderMyst {
    private AgeController controller;
    private static ChunkProfiler chunkprofiler;
    private static int chunkX_min;
    private static int chunkZ_min;
    private static int chunkZ_max;
    private int chunkX;
    private int chunkZ;
    private boolean chunkproviderreplaced;
    private static List<Biome> biomeList;

    public static void setChunkProfiler(ChunkProfiler profiler) {
        chunkprofiler = profiler;
    }

    public static void setBounds(int chunkX_min, int chunkX_max, int chunkZ_min, int chunkZ_max) {
        WorldProviderMystDummy.chunkX_min = chunkX_min;
        WorldProviderMystDummy.chunkZ_min = chunkZ_min;
        WorldProviderMystDummy.chunkZ_max = chunkZ_max;
    }

    private static boolean outOfBounds(int chunkX, int chunkZ) {
        return chunkZ < chunkZ_min || chunkZ > chunkZ_max || chunkX < chunkX_min;
    }

    @Override
    protected void func_76572_b() {
        this.chunkX = chunkX_min;
        this.chunkZ = chunkZ_min;
        this.agedata = new AgeData("CONTROL");
        this.agedata.setAgeName("CONTROL");
        this.agedata.setSpawn(null);
        this.agedata.setInstabilityEnabled(true);
        this.addBiomeSymbols(this.agedata);
        this.agedata.addSymbol(this.forMyst("BioConGrid"), 0);
        this.agedata.addSymbol(SymbolBlock.getSymbolIdentifier(Blocks.field_150348_b.func_176223_P()), 0);
        this.agedata.addSymbol(SymbolBlock.getSymbolIdentifier(Blocks.field_150355_j.func_176223_P()), 0);
        this.agedata.addSymbol(this.forMyst("TerrainNormal"), 0);
        this.agedata.addSymbol(SymbolBlock.getSymbolIdentifier(Blocks.field_150355_j.func_176223_P()), 0);
        this.agedata.addSymbol(this.forMyst("LakesSurface"), 0);
        this.agedata.addSymbol(SymbolBlock.getSymbolIdentifier(Blocks.field_150353_l.func_176223_P()), 0);
        this.agedata.addSymbol(this.forMyst("LakesDeep"), 0);
        this.agedata.addSymbol(this.forMyst("Caves"), 0);
        this.agedata.addSymbol(this.forMyst("Ravines"), 0);
        this.agedata.addSymbol(this.forMyst("Villages"), 0);
        this.agedata.addSymbol(this.forMyst("Mineshafts"), 0);
        this.agedata.addSymbol(this.forMyst("WeatherNorm"), 0);
        this.agedata.addSymbol(this.forMyst("LightingNormal"), 0);
        this.agedata.markVisited();
        this.controller = new AgeControllerDummy(this.field_76579_a, this.agedata);
        this.field_76578_c = this.controller.getBiomeProvider();
        this.setWorldInfo();
    }

    private ResourceLocation forMyst(String id) {
        return new ResourceLocation("mystcraft", id);
    }

    private void addBiomeSymbols(AgeData agedata) {
        if (biomeList == null) {
            WorldProviderMystDummy.getAndPrepareBiomeList();
        }
        for (Biome biome : biomeList) {
            agedata.addSymbol(SymbolBiome.getBiomeSymbolId("mystcraft", biome), 0);
        }
    }

    public static List<Biome> getAndPrepareBiomeList() {
        if (biomeList != null) {
            return biomeList;
        }
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            if (biomesToAdd == null) continue;
            for (BiomeManager.BiomeEntry biomeentry : biomesToAdd) {
                if (biomeentry == null) continue;
                biomeList.add(biomeentry.biome);
            }
        }
        biomeList.add(Biomes.field_76769_d);
        biomeList.add(Biomes.field_150588_X);
        biomeList.add(Biomes.field_76772_c);
        WorldProviderMystDummy.biomeList = biomeList;
        return biomeList;
    }

    @Override
    public AgeController getAgeController() {
        return this.controller;
    }

    @Override
    public String getDimensionName() {
        return "CONTROL";
    }

    @Override
    public void updateWeather() {
        this.getAgeController().tick();
        this.getAgeController().getWeatherController().updateRaining();
    }

    @Override
    public Biome getBiomeForCoords(BlockPos pos) {
        return this.field_76578_c.func_180631_a(pos);
    }

    @Override
    public boolean func_76566_a(int x, int z) {
        return true;
    }

    @Override
    public boolean func_76567_e() {
        return false;
    }

    @Override
    public void calculateInitialWeather() {
        super.calculateInitialWeather();
        this.replaceChunkProvider();
    }

    public void replaceChunkProvider() {
        if (this.chunkproviderreplaced) {
            return;
        }
        this.chunkproviderreplaced = true;
        WorldServer world = (WorldServer)this.field_76579_a;
        ChunkProviderServerDummy theChunkProviderServer = new ChunkProviderServerDummy(world, (IChunkLoader)new AnvilChunkLoaderDummy(((AnvilChunkLoader)world.func_72863_F().field_73247_e).field_75825_d), this.func_186060_c());
        ObfuscationReflectionHelper.setPrivateValue(World.class, (Object)world, (Object)((Object)theChunkProviderServer), (String[])new String[]{"chunkProvider", "field_73020_y"});
    }

    public void generateNextChunk() {
        ChunkProviderServer chunkgen = ((WorldServer)this.field_76579_a).func_72863_F();
        IChunkLoader chunkloader = ((WorldServer)this.field_76579_a).func_72863_F().field_73247_e;
        if (this.safeLoadChunk(chunkloader, this.field_76579_a, this.chunkX, this.chunkZ) == null) {
            chunkgen.func_186025_d(this.chunkX, this.chunkZ);
        }
        ++this.chunkZ;
        if (this.chunkZ > chunkZ_max) {
            this.chunkZ = chunkZ_min;
            ++this.chunkX;
        }
    }

    private Chunk safeLoadChunk(IChunkLoader chunkloader, World worldObj, int par1, int par2) {
        if (chunkloader == null) {
            return null;
        }
        try {
            return chunkloader.func_75815_a(worldObj, par1, par2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class AgeControllerDummy
    extends AgeController {
        public AgeControllerDummy(World worldObj, AgeData age) {
            super(worldObj, age);
        }

        @Override
        public ChunkProfiler getChunkProfiler() {
            return chunkprofiler;
        }

        @Override
        public void registerDebugInfo(DebugHierarchy.DebugNode node) {
        }
    }

    private static class ChunkProviderServerDummy
    extends ChunkProviderServer {
        private Chunk defaultEmptyChunk;
        private final Set<Long> droppedChunksSet = Sets.newHashSet();

        public ChunkProviderServerDummy(WorldServer worldServer, IChunkLoader loader, IChunkGenerator provider) {
            super(worldServer, loader, provider);
            this.defaultEmptyChunk = new MystEmptyChunk((World)worldServer, 0, 0);
        }

        public boolean func_73157_c() {
            return false;
        }

        public void func_73240_a() {
            for (Chunk chunk : this.field_73244_f.values()) {
                this.func_189549_a(chunk);
            }
        }

        public void func_189549_a(Chunk chunkIn) {
            if (this.field_73251_h.field_73011_w.func_186056_c(chunkIn.field_76635_g, chunkIn.field_76647_h)) {
                this.droppedChunksSet.add(ChunkPos.func_77272_a((int)chunkIn.field_76635_g, (int)chunkIn.field_76647_h));
                chunkIn.field_189550_d = true;
            }
        }

        @Nullable
        public Chunk func_186026_b(int x, int z) {
            long i = ChunkPos.func_77272_a((int)x, (int)z);
            Chunk chunk = (Chunk)this.field_73244_f.get(i);
            if (chunk != null) {
                chunk.field_189550_d = false;
            }
            return chunk;
        }

        public Chunk func_186028_c(int chunkX, int chunkZ) {
            if (WorldProviderMystDummy.outOfBounds(chunkX, chunkZ)) {
                return this.defaultEmptyChunk;
            }
            return super.func_186028_c(chunkX, chunkZ);
        }

        public boolean func_73156_b() {
            if (!this.droppedChunksSet.isEmpty() && this.droppedChunksSet.size() > 80) {
                Iterator<Long> iterator = this.droppedChunksSet.iterator();
                int i = 0;
                while (i < 100 && iterator.hasNext()) {
                    Long olong = iterator.next();
                    Chunk chunk = (Chunk)this.field_73244_f.get((Object)olong);
                    if (chunk != null && chunk.field_189550_d) {
                        chunk.func_76623_d();
                        this.field_73244_f.remove((Object)olong);
                        ++i;
                    }
                    iterator.remove();
                }
                this.field_73247_e.func_75817_a();
            }
            return false;
        }
    }

    private static class AnvilChunkLoaderDummy
    extends AnvilChunkLoader {
        public AnvilChunkLoaderDummy(File p_i2003_1_) {
            super(p_i2003_1_, null);
        }

        public boolean chunkExists(World world, int i, int j) {
            return false;
        }

        public Chunk func_75815_a(World p_75815_1_, int p_75815_2_, int p_75815_3_) throws IOException {
            return null;
        }
    }
}

