/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MystWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World worldObj, IChunkGenerator chunkGenerator, IChunkProvider ichunkprovider) {
        if (!(worldObj.field_73011_w instanceof WorldProviderMyst)) {
            return;
        }
        AgeController controller = ((WorldProviderMyst)worldObj.field_73011_w).getAgeController();
        BlockPos spawn = worldObj.func_175694_M();
        ChunkPos spawnChunk = null;
        if (spawn != null) {
            spawnChunk = new ChunkPos(spawn);
        }
        if (spawnChunk != null && spawnChunk.field_77276_a == chunkX && spawnChunk.field_77275_b == chunkZ) {
            MystWorldGenerator.generatePlatform(worldObj, spawn.func_177958_n(), spawn.func_177956_o() - 1, spawn.func_177952_p(), Blocks.field_150347_e);
        }
        ChunkProfiler profiler = controller.getChunkProfiler();
        this.profileCompletedChunks(profiler, chunkX, chunkZ, ichunkprovider);
    }

    private void profileCompletedChunks(ChunkProfiler profiler, int chunkX, int chunkZ, IChunkProvider ichunkprovider) {
        for (int i = chunkX - 1; i <= chunkX + 1; ++i) {
            for (int k = chunkZ - 1; k <= chunkZ + 1; ++k) {
                Chunk chunk;
                if (!ichunkprovider.func_191062_e(i, k) || !this.checkForCompletion(ichunkprovider, chunk = ichunkprovider.func_186025_d(i, k), i, k)) continue;
                ChunkProfilerManager.addChunk(profiler, chunk);
            }
        }
    }

    private boolean checkForCompletion(IChunkProvider ichunkprovider, Chunk chunk, int chunkX, int chunkZ) {
        if (!chunk.func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX - 1, chunkZ - 1)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX, chunkZ - 1)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX + 1, chunkZ - 1)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX - 1, chunkZ)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX + 1, chunkZ)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX - 1, chunkZ + 1)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX, chunkZ + 1)) {
            return false;
        }
        if (!ichunkprovider.func_191062_e(chunkX + 1, chunkZ + 1)) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX - 1, chunkZ - 1).func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX, chunkZ - 1).func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX + 1, chunkZ - 1).func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX - 1, chunkZ).func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX + 1, chunkZ).func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX - 1, chunkZ + 1).func_177419_t()) {
            return false;
        }
        if (!ichunkprovider.func_186025_d(chunkX, chunkZ + 1).func_177419_t()) {
            return false;
        }
        return ichunkprovider.func_186025_d(chunkX + 1, chunkZ + 1).func_177419_t();
    }

    private static void generatePlatform(World worldObj, int i, int j, int k, Block block) {
        int size = 2;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                for (int y = j + 1; y < j + 5; ++y) {
                    worldObj.func_180501_a(new BlockPos(i + x, y, k + z), Blocks.field_150350_a.func_176223_P(), 2);
                }
                worldObj.func_180501_a(new BlockPos(i + x, j, k + z), block.func_176223_P(), 2);
            }
        }
    }
}

