/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen.feature;

import com.xcompwiz.mystcraft.world.gen.MapGenAdvanced;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class WorldGenMystBigTree
extends MapGenAdvanced {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    static final int[] coordMaximums = new int[]{16, 255, 16};
    World worldObj;
    int[] blobPos = new int[]{0, 0, 0};
    int[] rootPos = new int[]{0, 0, 0};
    int blobHeight = 0;
    int[][] leafNodes;
    private static double scaleWidth = 0.2;
    private static int maxY = 180;
    private static int minY = 128;
    private static int leafDistanceLimit = 3;
    private static int trunkSize = 2;

    public WorldGenMystBigTree(long seed) {
        super(seed, Blocks.field_150364_r.func_176223_P());
    }

    void generateLeafNodeList(ChunkPrimer primer) {
        int i = 4;
        if (i < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.blobHeight][4];
        int j = this.blobPos[1] + this.blobHeight - leafDistanceLimit;
        int k = 1;
        int l = (int)((double)this.blobPos[1] + (double)this.blobHeight * 0.9);
        int i1 = j - this.blobPos[1];
        ai[0][0] = this.blobPos[0];
        ai[0][1] = j--;
        ai[0][2] = this.blobPos[2];
        ai[0][3] = l;
        int[] ai1 = new int[]{0, 0, 0};
        int[] ai2 = new int[]{0, 0, 0};
        int[] ai3 = new int[]{this.blobPos[0], 0, this.blobPos[2]};
        double d = 0.5;
        while (i1 >= 0) {
            float f = this.layerSize(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            for (int j1 = 0; j1 < i; ++j1) {
                double d1 = scaleWidth * ((double)f * ((double)this.rand.nextFloat() + 3.0));
                double d2 = (double)this.rand.nextFloat() * 2.0 * 3.14159;
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2) + (double)this.blobPos[0] + d));
                int l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.blobPos[2] + d));
                ai1[0] = k1;
                ai1[1] = j;
                ai1[2] = l1;
                ai2[0] = k1;
                ai2[1] = j + leafDistanceLimit;
                ai2[2] = l1;
                ai3[1] = j - 2;
                ai[k][0] = k1;
                ai[k][1] = j;
                ai[k][2] = l1;
                ai[k][3] = ai3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.leafNodes, 0, k);
    }

    void genTreeLayer(ChunkPrimer primer, int x, int y, int z, float f, byte axis0, IBlockState block) {
        int radius = (int)((double)f + 0.618);
        float f2 = f * f;
        byte axis1 = otherCoordPairs[axis0];
        byte axis2 = otherCoordPairs[axis0 + 3];
        int[] basePos = new int[]{x, y, z};
        int[] localPos = new int[]{0, 0, 0};
        localPos[axis0] = basePos[axis0];
        if (localPos[axis0] < 0 || localPos[axis0] >= coordMaximums[axis0]) {
            return;
        }
        for (int axis1Offset = -radius; axis1Offset <= radius; ++axis1Offset) {
            localPos[axis1] = basePos[axis1] + axis1Offset;
            if (localPos[axis1] < 0 || localPos[axis1] >= coordMaximums[axis1]) continue;
            for (int axis2Offset = -radius; axis2Offset <= radius; ++axis2Offset) {
                localPos[axis2] = basePos[axis2] + axis2Offset;
                if (localPos[axis2] < 0 || localPos[axis2] >= coordMaximums[axis2] || !(Math.pow((double)axis1Offset + 0.5, 2.0) + Math.pow((double)axis2Offset + 0.5, 2.0) < (double)f2)) continue;
                this.placeBlock(primer, localPos[0], localPos[1], localPos[2], block);
            }
        }
    }

    float layerSize(int i) {
        if ((double)i < (double)this.blobHeight * 0.75) {
            return -1.618f;
        }
        float f = (float)this.blobHeight * 0.5f;
        float f1 = (float)this.blobHeight * 0.5f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)WorldGenMystBigTree.sqrt(Math.pow(f, 2.0) - Math.pow(f1, 2.0)));
        return f2 *= 0.5f;
    }

    public static double sqrt(double a) {
        long x = Double.doubleToLongBits(a) >> 32;
        double y = Double.longBitsToDouble(x + 1072632448L << 31);
        return y;
    }

    float leafSize(int i) {
        if (i < 0 || i >= leafDistanceLimit) {
            return -1.0f;
        }
        return i != 0 && i != leafDistanceLimit - 1 ? 3.0f : 2.0f;
    }

    void generateLeafNode(ChunkPrimer primer, int i, int j, int k) {
        int i1 = j + leafDistanceLimit;
        for (int l = j; l < i1; ++l) {
            float f = this.leafSize(l - j);
            if (f < 0.0f) continue;
            this.genTreeLayer(primer, i, l, k, f, (byte)1, Blocks.field_150362_t.func_176223_P());
        }
    }

    void placeBlockLine(ChunkPrimer primer, int[] startPoint, int[] endPoint, IBlockState i) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = endPoint[byte0] - startPoint[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] localPos = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            localPos[j] = MathHelper.func_76128_c((double)((double)(startPoint[j] + k) + 0.5));
            localPos[byte1] = MathHelper.func_76128_c((double)((double)startPoint[byte1] + (double)k * d + 0.5));
            localPos[byte2] = MathHelper.func_76128_c((double)((double)startPoint[byte2] + (double)k * d1 + 0.5));
            if (localPos[0] < 0 || localPos[0] >= 16 || localPos[1] < 0 || localPos[1] >= 255 || localPos[2] < 0 || localPos[2] >= 16) continue;
            this.placeBlock(primer, localPos[0], localPos[1], localPos[2], i);
        }
    }

    void generateLeaves(ChunkPrimer primer) {
        for (int i = 0; i < this.leafNodes.length; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(primer, k, l, i1);
        }
    }

    boolean leafNodeNeedsBase(int i) {
        return (double)i >= (double)this.blobHeight * 0.2;
    }

    void generateTrunk(ChunkPrimer primer) {
        int i = this.rootPos[0];
        int j = this.rootPos[1];
        int k = (int)((double)this.blobPos[1] + (double)this.blobHeight * 0.9);
        int l = this.rootPos[2];
        int[] ai = new int[]{i, j, l};
        int[] ai1 = new int[]{i, k, l};
        this.placeBlockLine(primer, ai, ai1, Blocks.field_150364_r.func_176223_P());
        if (trunkSize == 2) {
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            if (ai[0] >= 0 && ai[0] < coordMaximums[0] && ai[2] >= 0 && ai[2] < coordMaximums[2]) {
                this.placeBlockLine(primer, ai, ai1, Blocks.field_150364_r.func_176223_P());
            }
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            if (ai[0] >= 0 && ai[0] < coordMaximums[0] && ai[2] >= 0 && ai[2] < coordMaximums[2]) {
                this.placeBlockLine(primer, ai, ai1, Blocks.field_150364_r.func_176223_P());
            }
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            if (ai[0] >= 0 && ai[0] < coordMaximums[0] && ai[2] >= 0 && ai[2] < coordMaximums[2]) {
                this.placeBlockLine(primer, ai, ai1, Blocks.field_150364_r.func_176223_P());
            }
        }
    }

    void generateRoots(ChunkPrimer primer) {
        int i = this.rootPos[0];
        int j = this.rootPos[1];
        int k = this.rootPos[2];
        int[] ai = new int[]{i, j + 1, k};
        int[] ai1 = new int[]{i, j, k};
        int range = this.rootPos[1];
        int count = this.blobHeight >> 2;
        for (int c = 0; c < count; ++c) {
            ai[0] = i + c % 2;
            ai[2] = k + (c > 2 ? 1 : 0);
            ai1[0] = i + this.rand.nextInt(13) - 6;
            ai1[1] = j - this.rand.nextInt(range + 1) - 3;
            ai1[2] = k + this.rand.nextInt(13) - 6;
            this.placeBlockLine(primer, ai, ai1, Blocks.field_150364_r.func_176223_P());
        }
    }

    void generateLeafNodeBases(ChunkPrimer primer) {
        int j = this.leafNodes.length;
        int[] ai = new int[]{this.blobPos[0], this.blobPos[1], this.blobPos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.leafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.blobPos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(primer, ai, ai2, Blocks.field_150364_r.func_176223_P());
        }
    }

    @Override
    protected void recursiveGenerate(World worldObj, int x, int z, int chunkX, int chunkZ, ChunkPrimer primer) {
        if (this.rand.nextInt(2) != 0) {
            return;
        }
        int pX = x * 16 + this.rand.nextInt(16) - chunkX * 16;
        int pY = this.rand.nextInt(8) + 4;
        int pZ = z * 16 + this.rand.nextInt(16) - chunkZ * 16;
        this.rootPos[0] = this.blobPos[0] = pX;
        this.rootPos[1] = this.blobPos[1] = pY;
        this.rootPos[2] = this.blobPos[2] = pZ;
        this.blobPos[1] = this.rand.nextInt(maxY - minY + 1) + minY;
        this.blobHeight = this.rand.nextInt(30) + 40;
        this.generateLeafNodeList(primer);
        this.generateLeaves(primer);
        this.generateTrunk(primer);
        this.generateRoots(primer);
        this.generateLeafNodeBases(primer);
    }
}

