/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;

public class ArrayMappingUtils {
    public static void mapLocalToVanilla(IBlockState[] arr1, IBlockState[] arr2) {
        int len = arr1.length;
        if (len != arr2.length) {
            throw new RuntimeException("Cannot map data indicies: Arrays of different lengths");
        }
        int maxy = len / 256;
        for (int y = 0; y < maxy; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int lcoords = y << 8 | z << 4 | x;
                    int vcoords = (x << 4 | z) * maxy | y;
                    arr2[vcoords] = arr1[lcoords];
                }
            }
        }
    }

    public static void mapVanillaToLocal(IBlockState[] arr1, IBlockState[] arr2) {
        int len = arr1.length;
        if (len != arr2.length) {
            throw new RuntimeException("Cannot map data indicies: Arrays of different lengths");
        }
        int maxy = len / 256;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < maxy; ++y) {
                    int lcoords = y << 8 | z << 4 | x;
                    int vcoords = (x << 4 | z) * maxy | y;
                    if (y < 6 && Blocks.field_150357_h == arr1[vcoords]) continue;
                    arr2[lcoords] = arr1[vcoords];
                }
            }
        }
    }

    public static void fillPrimerVanillaIndexing(ChunkPrimer cp, IBlockState[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            IBlockState state = blocks[i];
            if (state == null) continue;
            BlockPos vanillaIndex = ArrayMappingUtils.getVanillaPos(i);
            cp.func_177855_a(vanillaIndex.func_177958_n(), vanillaIndex.func_177956_o(), vanillaIndex.func_177952_p(), state);
        }
    }

    private static BlockPos getVanillaPos(int index) {
        int x = index >> 12 & 0xF;
        int z = index >> 8 & 0xF;
        int y = index & 0xFF;
        return new BlockPos(x, y, z);
    }
}

