/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.words;

import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.banners.BannerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DrawableWordManager {
    private static HashMap<String, DrawableWord> words = new HashMap();

    public static Map<String, DrawableWord> getWords() {
        return Collections.unmodifiableMap(words);
    }

    public static void registerWord(String name, DrawableWord word) {
        if ((name = name.toLowerCase()) == null || word == null) {
            return;
        }
        if (words.containsKey(name)) {
            return;
        }
        words.put(name, word);
        BannerUtils.addBasicPattern(name);
    }

    public static void registerWord(String name, Integer[] components) {
        if (name == null || components == null) {
            return;
        }
        DrawableWordManager.registerWord(name, new DrawableWord(components));
    }

    public static DrawableWord getDrawableWord(String string) {
        if (string == null) {
            return null;
        }
        DrawableWord word = words.get(string = string.toLowerCase());
        if (word == null) {
            word = new DrawableWord();
            Random rand = new Random(string.hashCode());
            int maxcompindex = 20;
            int count = rand.nextInt(10) + 3;
            if (string.startsWith("easter")) {
                count = 4;
                maxcompindex = 8;
            }
            for (int i = 0; i < count; ++i) {
                word.components().add(rand.nextInt(maxcompindex) + 4);
            }
            words.put(string, word);
        }
        return word;
    }
}

