/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.villager;

import com.google.common.collect.MapMaker;
import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.data.ModGUIs;
import com.xcompwiz.mystcraft.inventory.InventoryVillager;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class VillagerTradeSystem {
    private static ConcurrentMap<EntityVillager, InventoryVillager> villagers = new MapMaker().weakKeys().weakValues().makeMap();
    private static long tick_accumulator = 0L;

    public static boolean onVillagerInteraction(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (!Mystcraft.archivistEnabled()) {
            return false;
        }
        if (!(event.getTarget() instanceof EntityVillager)) {
            return false;
        }
        EntityVillager villager = (EntityVillager)event.getTarget();
        if (!villager.getProfessionForge().equals((Object)Mystcraft.instance.archivist)) {
            return false;
        }
        if (event.getEntityPlayer().func_70093_af()) {
            return false;
        }
        event.getEntityPlayer().openGui((Object)Mystcraft.instance, ModGUIs.VILLAGER.ordinal(), event.getEntityPlayer().field_70170_p, villager.func_145782_y(), 0, 0);
        return true;
    }

    public static void onTick() {
        if (++tick_accumulator % 1000L == 0L) {
            for (InventoryVillager villagerinv : villagers.values()) {
                villagerinv.simulate();
            }
        }
    }

    public static InventoryVillager getVillagerInventory(EntityVillager villager) {
        if (villager.field_70170_p.field_72995_K) {
            return new InventoryVillager(villager);
        }
        InventoryVillager villagerinv = (InventoryVillager)villagers.get(villager);
        if (villagerinv == null) {
            villagerinv = new InventoryVillager(villager);
            villagerinv.readFromNBT(villager.getEntityData().func_74775_l("Mystcraft").func_74775_l("Trade"));
            villagers.put(villager, villagerinv);
            villagerinv.simulate();
        }
        return villagerinv;
    }

    public static void release(InventoryVillager villagerinv) {
        if (villagerinv.isDirty()) {
            villagerinv.writeToNBT(NBTUtils.forceGetCompound(NBTUtils.forceGetCompound(villagerinv.getVillager().getEntityData(), "Mystcraft"), "Trade"));
        }
    }

    public static int getCardCost(@Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return 0;
        }
        Integer rank = SymbolManager.getSymbolItemCardRank(Page.getSymbol(itemstack));
        if (rank == null) {
            return 100;
        }
        return 4 * (1 + rank);
    }
}

