/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.TerrainGeneratorBase;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class SymbolTerrainGenNether
extends SymbolBase {
    public SymbolTerrainGenNether(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        TerrainGenerator gen = new TerrainGenerator(controller);
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.SEA);
        if (block != null) {
            gen.setSeaBlock(block.blockstate);
        }
        if ((block = ModifierUtils.popBlockMatching(controller, BlockCategory.TERRAIN)) != null) {
            gen.setTerrainBlock(block.blockstate);
        }
        controller.registerInterface(gen);
        controller.setCloudHeight(200.0f);
        controller.setHorizon(128.0);
        controller.setSeaLevel(32);
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static class TerrainGenerator
    extends TerrainGeneratorBase {
        private Random rand;
        private NoiseGeneratorOctaves noiseGen1;
        private NoiseGeneratorOctaves noiseGen2;
        private NoiseGeneratorOctaves noiseGen3;
        private NoiseGeneratorOctaves noiseGen4;
        private NoiseGeneratorOctaves noiseGen5;
        private double[] noiseData1;
        private double[] noiseData2;
        private double[] noiseData3;
        private double[] noiseData4;
        private double[] noiseData5;

        public TerrainGenerator(AgeDirector controller) {
            super(controller);
            this.rand = new Random(controller.getSeed());
            this.bedrockGen = new Random(controller.getSeed());
            this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
            this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
            this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
            this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
            this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
        }

        @Override
        protected double[] initializeNoiseField(double[] noise_field, int subchunkX, int subchunkY, int subchunkZ, int sizeX, int sizeY, int sizeZ) {
            if (noise_field == null) {
                noise_field = new double[sizeX * sizeY * sizeZ];
            }
            double cfactor1 = 684.412;
            double cfactor2 = 2053.236;
            this.noiseData4 = this.noiseGen4.func_76304_a(this.noiseData4, subchunkX, subchunkY, subchunkZ, sizeX, 1, sizeZ, 1.0, 0.0, 1.0);
            this.noiseData5 = this.noiseGen5.func_76304_a(this.noiseData5, subchunkX, subchunkY, subchunkZ, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
            this.noiseData3 = this.noiseGen3.func_76304_a(this.noiseData3, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, cfactor1 / 80.0, cfactor2 / 60.0, cfactor1 / 80.0);
            this.noiseData1 = this.noiseGen1.func_76304_a(this.noiseData1, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, cfactor1, cfactor2, cfactor1);
            this.noiseData2 = this.noiseGen2.func_76304_a(this.noiseData2, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, cfactor1, cfactor2, cfactor1);
            int i = 0;
            int j = 0;
            double[] ad = new double[sizeY];
            for (int y = 0; y < sizeY; ++y) {
                ad[y] = Math.cos((double)y * Math.PI * 6.0 / (double)sizeY) * 2.0;
                double d2 = y;
                if (y > sizeY / 2) {
                    d2 = sizeY - 1 - y;
                }
                if (!(d2 < 4.0)) continue;
                d2 = 4.0 - d2;
                int n = y;
                ad[n] = ad[n] - d2 * d2 * d2 * 10.0;
            }
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    double d3 = (this.noiseData4[j] + 256.0) / 512.0;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    double d4 = 0.0;
                    double d5 = this.noiseData5[j] / 8000.0;
                    if (d5 < 0.0) {
                        d5 = -d5;
                    }
                    if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                        if ((d5 /= 2.0) < -1.0) {
                            d5 = -1.0;
                        }
                        d5 /= 1.4;
                        d5 /= 2.0;
                        d3 = 0.0;
                    } else {
                        if (d5 > 1.0) {
                            d5 = 1.0;
                        }
                        d5 /= 6.0;
                    }
                    d3 += 0.5;
                    d5 = d5 * (double)sizeY / 16.0;
                    ++j;
                    for (int j1 = 0; j1 < sizeY; ++j1) {
                        double d6 = 0.0;
                        double d7 = ad[j1];
                        double d8 = this.noiseData1[i] / 512.0;
                        double d9 = this.noiseData2[i] / 512.0;
                        double d10 = (this.noiseData3[i] / 10.0 + 1.0) / 2.0;
                        d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                        d6 -= d7;
                        if (j1 > sizeY - 4) {
                            double d11 = (float)(j1 - (sizeY - 4)) / 3.0f;
                            d6 = d6 * (1.0 - d11) + -10.0 * d11;
                        }
                        if ((double)j1 < d4) {
                            double d12 = (d4 - (double)j1) / 4.0;
                            if (d12 < 0.0) {
                                d12 = 0.0;
                            }
                            if (d12 > 1.0) {
                                d12 = 1.0;
                            }
                            d6 = d6 * (1.0 - d12) + -10.0 * d12;
                        }
                        noise_field[i] = d6;
                        ++i;
                    }
                }
            }
            return noise_field;
        }
    }
}

