/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.utility.ReflectionUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class SymbolBiome
extends SymbolBase {
    public static ArrayList<Biome> selectables = new ArrayList();
    private Biome biome;
    private String unlocalizedBiomeName;

    public static ResourceLocation getBiomeSymbolId(String ownerModid, Biome biome) {
        return new ResourceLocation(ownerModid, "Biome" + Biome.func_185362_a((Biome)biome));
    }

    public SymbolBiome(String ownerModid, Biome biome) {
        super(SymbolBiome.getBiomeSymbolId(ownerModid, biome));
        this.biome = biome;
        this.unlocalizedBiomeName = SymbolBiome.formatted(biome);
        this.setWords(new String[]{"Nature", "Nurture", "Encourage", ReflectionUtil.getBiomeName(biome) + Biome.func_185362_a((Biome)biome)});
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static String formatted(Biome biome) {
        String regex = "([A-Z][a-z]+_*)";
        String replacement = "$1 ";
        String name = ReflectionUtil.getBiomeName(biome).replaceAll(regex, replacement).replaceAll("([A-Z][a-z]+) +", replacement).trim();
        if (name.endsWith("Biome")) {
            name = name.substring(0, name.length() - "Biome".length()).trim();
        }
        return name;
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        controller.setAverageGroundLevel((int)(this.biome.func_185355_j() * 64.0f + 64.0f));
        ModifierUtils.pushBiome(controller, this.biome);
    }

    @Override
    public String generateLocalizedName() {
        return I18n.func_135052_a((String)"myst.symbol.biome.wrapper", (Object[])new Object[]{this.unlocalizedBiomeName});
    }

    public static Biome getRandomBiome(Random rand) {
        Biome biome = null;
        while (biome == null) {
            if (selectables.size() > 0) {
                biome = selectables.get(rand.nextInt(selectables.size()));
                continue;
            }
            biome = Biome.func_150568_d((int)rand.nextInt(Biome.field_185377_q.func_148742_b().size()));
        }
        return biome;
    }
}

